package com.aote.abc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;







import org.apache.commons.codec.binary.Base64;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.junit.Test;

import com.aote.utils.Base64Util;

public class AbcUtil {

	static Logger log = Logger.getLogger(AbcUtil.class);
	/**
	 * 签名
	 * @param dataString
	 * @param PFXPATH
	 * @param KEYSTORE_PASSWORD
	 * @return
	 */
	public static String signWhithsha1withrsa(String dataString,String PFXPATH,String KEYSTORE_PASSWORD) {
		String signatureString = null;
		String filePath=AbcUtil.class.getResource("/certs").getPath()+PFXPATH;
		try {
			KeyStore ks = KeyStore.getInstance("PKCS12");
			FileInputStream fis = new FileInputStream(filePath);
			char[] nPassword = null;
			if ((KEYSTORE_PASSWORD == null)
					|| KEYSTORE_PASSWORD.trim().equals("")) {
				nPassword = null;
			} else {
				nPassword = KEYSTORE_PASSWORD.toCharArray();
			}
			ks.load(fis, nPassword);
			fis.close();
			System.out.println("keystore type=" + ks.getType());
			Enumeration<String> enums = ks.aliases();
			String keyAlias = null;
			if (enums.hasMoreElements()) 
			{
				keyAlias = (String) enums.nextElement();
				System.out.println("alias=[" + keyAlias + "]");
			}
			System.out.println("is key entry=" + ks.isKeyEntry(keyAlias));
			PrivateKey prikey = (PrivateKey) ks.getKey(keyAlias, nPassword);
			java.security.cert.Certificate cert = ks.getCertificate(keyAlias);
			PublicKey pubkey = cert.getPublicKey();
			System.out.println("cert class = " + cert.getClass().getName());
			System.out.println("cert = " + cert);
			System.out.println("public key = " + pubkey);
			System.out.println("private key = " + prikey);
			// SHA1withRSA算法进行签名
			Signature sign = Signature.getInstance("SHA1withRSA");
			sign.initSign(prikey);
			byte[] data = dataString.getBytes("utf-8");
			byte[] dataBase= Base64.encodeBase64(data);
			// 更新用于签名的数据
			sign.update(dataBase);
			byte[] signature = sign.sign();
			signatureString = new String(Base64.encodeBase64(signature));
			System.out.println("--------signature is : " + signatureString);
		} catch (Exception e) {
			e.printStackTrace();
		}
		return signatureString;
	}

	/**
	 * 读取cer并验证公钥签名
	 */
	public static boolean verify_sign(String requsetBody, String signature,String CERPATH) {
		
		String filePath=AbcUtil.class.getResource("/certs").getPath()+CERPATH;
		X509Certificate cert = null;
		boolean flag = false;
		try {
			CertificateFactory cf = CertificateFactory.getInstance("X.509");
			cert = (X509Certificate) cf
					.generateCertificate(new FileInputStream(new File(
							filePath)));
			PublicKey publicKey = cert.getPublicKey();
			String publicKeyString = new String(Base64.encodeBase64(publicKey
					.getEncoded()));
			System.out.println("-----------------公钥--------------------");
			System.out.println(publicKeyString);
			System.out.println("-----------------公钥--------------------");
			Signature verifySign = Signature.getInstance("SHA1withRSA");
			verifySign.initVerify(publicKey);
			// 用于验签的数据
			verifySign.update(requsetBody.getBytes("utf-8"));
			 flag = verifySign.verify(com.alibaba.fastjson.util.Base64
					.decodeFast(signature));// 验签由第三方做
		} catch (InvalidKeyException e) {
			e.printStackTrace();
		} catch (NoSuchAlgorithmException e) {
			e.printStackTrace();
		} catch (SignatureException e) {
			e.printStackTrace();
		} catch (CertificateException e) {
			e.printStackTrace();
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		}catch (UnsupportedEncodingException e) {
			e.printStackTrace();
		}
		return flag;
	}
	
	/**
	 * 接收报文返回requsetBody和使用base64解析后的requsetBody以及缴费中心传送的签名
	 */

	public static JSONObject requestBodyOfBase64(String requestContent){

		JSONObject result = new JSONObject();
		log.debug("收到的报文："+requestContent);
		
		String signatureString = requestContent.substring(0,
				requestContent.indexOf("||"));
		log.debug("截取报文的signatureString:"+ signatureString);
		String requsetBody = requestContent.substring(signatureString
				.length() + 2);
		log.debug("截取报文的requsetBody:"+requsetBody);
		String requsetBodyOfDecoded = new String(
				Base64Util.decodeData(requsetBody));
		System.out.println("-----解析完成后的requsetBody-------" + requsetBodyOfDecoded);
		//使用base64解析完成后的requsetBody
		result.put("data",new JSONObject(requsetBodyOfDecoded));
		//解析前的requsetBody
		result.put("requsetBody",requsetBody);
		//获取缴费中心传送过来的签名
		result.put("sign",signatureString);
		return result;
		
	} 
	/**
	 * URI编码
	 * @param json
	 * @return
	 */
	public static String URIEncode (JSONObject json) {
		String ret = URLEncoder.encode(json.toString());
		return ret;
	}
	
	
}
