/*
 * Decompiled with CFR 0.152.
 */
package com.af.path;

import com.af.path.ClassHelper;
import com.af.path.Delegate;
import com.af.path.Expression;
import com.af.path.StringHelper;
import com.af.path.SubQuery;
import com.af.path.TypeGarther;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UnionSubQuery
extends SubQuery {
    private Map<String, Integer> maxLen = new HashMap<String, Integer>();

    public UnionSubQuery(Delegate delegate) {
        super(delegate);
    }

    @Override
    protected UnionSubQuery Clone() {
        UnionSubQuery result = new UnionSubQuery(this.delegate);
        result.copyFrom(this);
        return result;
    }

    @Override
    protected String toSubSelfSelect(String put, SubQuery parent) {
        String type = this.entity + this.ID + "_type";
        if (put != null) {
            type = put + " " + type;
        }
        String id = this.entity + this.ID + "_" + this.getKey();
        if (put != null) {
            id = put + " " + id;
        }
        StringBuilder result = new StringBuilder(type + "," + id);
        String append = this.toOrderSubSelect();
        StringHelper.join(result, append);
        return result.toString();
    }

    private String toSelect(SubQuery query, String type) {
        int start;
        StringBuilder result = new StringBuilder();
        TypeGarther garther = query.getFieldByType(type);
        String append = query.toTypeSelect(type, true);
        StringHelper.join(result, append);
        for (int i = start = query.getFieldByType((String)type).len; i < this.maxLen.get(type); ++i) {
            append = "null " + ClassHelper.getTypeString(type) + (i + garther.start);
            StringHelper.join(result, append);
        }
        return result.toString();
    }

    @Override
    protected void split(Map<String, Object> map, List<Map<String, Object>> result, SubQuery parent) {
        String type = this.entity + this.ID + "_type";
        String typeName = (String)map.get(type);
        if (typeName == null) {
            return;
        }
        for (SubQuery sub : this.children) {
            if (!sub.tableName.equals(typeName)) continue;
            sub.split(map, result, parent);
        }
    }

    @Override
    protected String toTypeSelect(String type, boolean isSelf) {
        StringBuilder result = new StringBuilder();
        if (isSelf) {
            return "";
        }
        TypeGarther garther = this.getFieldByType(type);
        int max = this.maxLen.get(type);
        for (int i = 0; i < max; ++i) {
            String append = ClassHelper.getTypeString(type) + (i + garther.start);
            StringHelper.join(result, append);
        }
        return result.toString();
    }

    protected String toSelect(SubQuery query) {
        StringBuilder result = new StringBuilder();
        String append = "'" + query.tableName + "' " + this.entity + this.ID + "_type";
        StringHelper.join(result, append);
        String key = this.getKey();
        append = key + " " + this.entity + this.ID + "_" + key;
        StringHelper.join(result, append);
        String foreignkey = this.getForeignKey();
        append = foreignkey + " c_" + this.entity + this.ID + "_" + foreignkey;
        StringHelper.join(result, append);
        for (String type : ClassHelper.getTypes()) {
            append = this.toSelect(query, type);
            StringHelper.join(result, append);
        }
        for (SubQuery sub : this.children) {
            if (sub.equals(query)) {
                append = sub.toSelfSelect(null);
                StringHelper.join(result, append);
                continue;
            }
            append = sub.toSelfSelect("null");
            StringHelper.join(result, append);
        }
        return result.toString();
    }

    @Override
    public List<SubQuery> split() {
        ArrayList<SubQuery> result = new ArrayList<SubQuery>();
        for (SubQuery sub : this.children) {
            List<SubQuery> queries = sub.split();
            int i = 0;
            for (SubQuery query : queries) {
                if (result.size() > i) {
                    SubQuery c = (SubQuery)result.get(i);
                    c.Add(query);
                } else {
                    UnionSubQuery newUnion = this.Clone();
                    newUnion.Add(query);
                    result.add(newUnion);
                }
                ++i;
            }
        }
        return result;
    }

    @Override
    protected int computeFieldCol(String type, int start) {
        int max = 0;
        for (SubQuery sub : this.children) {
            int len = sub.computeFieldCol(type, start);
            if (len <= max) continue;
            max = len;
        }
        this.maxLen.put(type, max);
        TypeGarther garther = this.getFieldByType(type);
        garther.start = start;
        int len = max;
        if (this.conditionSub != null) {
            len += this.conditionSub.computeFieldCol(type, start + len);
        }
        garther.len = len;
        return max;
    }

    private String toOrderSubSelect() {
        StringBuilder result = new StringBuilder();
        for (Expression exp : this.orders) {
            exp.delegate.queries.push(this);
            String order = (String)exp.invoke2(this);
            exp.delegate.queries.pop();
            if (order.endsWith("_desc")) {
                String name = order.substring(0, order.length() - 5);
                StringHelper.join(result, this.entity + this.ID + "_" + name);
                continue;
            }
            StringHelper.join(result, this.entity + this.ID + "_" + order);
        }
        return result.toString();
    }

    private String toOrderSelect() {
        StringBuilder result = new StringBuilder();
        for (Expression exp : this.orders) {
            exp.delegate.queries.push(this);
            String order = (String)exp.invoke2(this);
            exp.delegate.queries.pop();
            if (order.endsWith("_desc")) {
                String name = order.substring(0, order.length() - 5);
                StringHelper.join(result, "p." + name + " " + this.entity + this.ID + "_" + name);
                continue;
            }
            StringHelper.join(result, "p." + order + " " + this.entity + this.ID + "_" + order);
        }
        return result.toString();
    }

    @Override
    protected String getSql() {
        String result = "";
        for (SubQuery sub : this.children) {
            String subSql = sub.getSql();
            if (!result.equals("")) {
                result = result + " union all ";
            }
            result = result + subSql;
        }
        String theId = this.getKey();
        StringBuilder sb = new StringBuilder("u.*");
        String select = StringHelper.join(sb, this.toOrderSelect()).toString();
        String from = this.toFrom();
        result = "select " + select + " from " + from + " p join (" + result + ") u on p." + theId + "=u." + this.entity + this.ID + "_" + theId;
        return result;
    }

    private String toFrom() {
        String result = null;
        result = this.conditionSub != null ? "(" + this.conditionSub.getSql() + ")" : this.tableName;
        return result;
    }

    @Override
    protected void combine(List<Map<String, Object>> result, List<Map<String, Object>> list) {
        for (SubQuery sub : this.children) {
            List<Map<String, Object>> subList = this.getDataByType(list, sub.tableName);
            List<Map<String, Object>> subResult = this.getDataByType(result, sub.tableName);
            if (subResult.size() > 0) {
                sub.combine(subResult, subList);
                continue;
            }
            if (subResult.size() != 0) continue;
            subResult.addAll(subList);
        }
    }

    private List<Map<String, Object>> getDataByType(List<Map<String, Object>> list, String type) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        if (list == null) {
            return result;
        }
        for (Map<String, Object> map : list) {
            if (!map.get("type").equals(type)) continue;
            result.add(map);
        }
        return result;
    }

    @Override
    protected String getFieldName(String field) {
        return this.entity + this.ID + "_" + field;
    }

    @Override
    public UnionSubQuery toUnionSubQuery() {
        return this;
    }

    @Override
    protected String toSelfString() {
        return "unionClass: " + this.entity + "," + this.tableName;
    }
}

