/*
 * Decompiled with CFR 0.152.
 */
package com.af.path;

import com.af.path.Type;
import com.af.util.Pair;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassHelper {
    static String packageName = "com.af.entity.";
    static List<Class<?>> classes = null;
    static List<String> types = null;

    public static String getTypeString(String t) {
        if (t.equals("STRING") || t.equals("COL_STRING")) {
            return "s";
        }
        if (t.equals("DATE") || t.equals("COL_DATE")) {
            return "d";
        }
        if (t.equals("NUMBER") || t.equals("COL_INTEGER")) {
            return "n";
        }
        if (t.equals("TIME") || t.equals("COL_TIME")) {
            return "t";
        }
        if (t.equals("BOOLEAN") || t.equals("COL_BOOLEAN")) {
            return "b";
        }
        throw new RuntimeException("\u6ca1\u6709\u8be5\u7c7b\u578b\u7684\u5b57\u7b26\u4e32\u8868\u793a" + t);
    }

    public static List<String> getTypes() {
        if (types == null) {
            types = new ArrayList<String>();
            types.add("STRING");
            types.add("DATE");
            types.add("NUMBER");
            types.add("TIME");
            types.add("BOOLEAN");
            types.add("COL_STRING");
            types.add("COL_DATE");
            types.add("COL_INTEGER");
            types.add("COL_TIME");
            types.add("COL_BOOLEAN");
        }
        return types;
    }

    public static boolean isInterface(String table) {
        try {
            Class<?> c = Class.forName(packageName + table);
            return c.isInterface();
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public static List<String> getFieldNames(String table, Map<String, HashMap<String, Object>> factory) {
        ArrayList<String> result = new ArrayList<String>();
        if (ClassHelper.isInterface(table)) {
            return result;
        }
        Map meta = factory.get(table);
        Map columns = (Map)meta.get("columns");
        result.addAll(columns.keySet());
        columns = (Map)meta.get("onetomany");
        result.addAll(columns.keySet());
        columns = (Map)meta.get("onetoone");
        result.addAll(columns.keySet());
        columns = (Map)meta.get("inverses");
        result.addAll(columns.keySet());
        return result;
    }

    public static String getKey(String table, Map<String, HashMap<String, Object>> factory) {
        Map cm = factory.get(table);
        if (cm == null) {
            throw new RuntimeException("\u627e\u4e0d\u5230\u8868\uff1a" + table);
        }
        String key = (String)cm.get("idColName");
        return key;
    }

    public static String getForiegnKey(String table, String name, Map<String, HashMap<String, Object>> factory) {
        String foreignKey = ClassHelper.getForeignKeyFromHibernate(table, name, factory);
        if (foreignKey != null) {
            return foreignKey;
        }
        throw new RuntimeException("\u8868" + table + "\u6ca1\u6709" + name + "\u5c5e\u6027");
    }

    public static Type getType(Map<String, Object> cm, String name) {
        Map columns = (Map)cm.get("columns");
        if (columns.containsKey(name)) {
            Pair pair = (Pair)columns.get(name);
            String type = pair.type;
            return new Type(type);
        }
        columns = (Map)cm.get("onetoone");
        if (columns.containsKey(name)) {
            Pair column = (Pair)columns.get(name);
            return new Type(column.col, column.type, false);
        }
        columns = (Map)cm.get("onetomany");
        if (columns.containsKey(name)) {
            Pair column = (Pair)columns.get(name);
            return new Type(column.col, column.type, true);
        }
        columns = (Map)cm.get("inverses");
        if (columns.containsKey(name)) {
            String column = (String)columns.get(name);
            return new Type(column, name, false);
        }
        String idName = (String)cm.get("idName");
        if (idName.equals(name)) {
            String idType = (String)cm.get("idType");
            return new Type(idType);
        }
        return null;
    }

    private static String getForeignKeyFromHibernate(String table, String name, Map<String, HashMap<String, Object>> factory) {
        Map cm = factory.get(table);
        if (cm == null) {
            throw new RuntimeException("\u8868" + table + "\u5728hibernate\u91cc\u6ca1\u6709\u914d\u7f6e!");
        }
        Type type = ClassHelper.getType(cm, name);
        if (!type.isAssociation) {
            return null;
        }
        String foreignkey = type.foriegnKey;
        return foreignkey;
    }

    public static List<String> getExtendClass(String entity, HashMap<String, HashMap<String, Object>> cm) {
        ArrayList<String> result = new ArrayList<String>();
        Map c = cm.get(entity);
        if (!c.containsKey("subclasses")) {
            result.add(entity);
            return result;
        }
        c = (Map)c.get("subclasses");
        result.addAll(c.keySet());
        return result;
    }

    public static List<Class<?>> getClassInPackage(String packName) {
        if (classes != null) {
            return classes;
        }
        ArrayList result = new ArrayList();
        String path = packName.replace('.', '/');
        try {
            Enumeration<URL> dirs = Thread.currentThread().getContextClassLoader().getResources(path);
            while (dirs.hasMoreElements()) {
                URL url = dirs.nextElement();
                String protocol = url.getProtocol();
                if ("file".equals(protocol)) {
                    String filePath = URLDecoder.decode(url.getFile(), "UTF-8");
                    result.addAll(ClassHelper.getClassInPath(packName, filePath));
                    continue;
                }
                if (!"jar".equals(protocol)) continue;
                JarFile jar = ((JarURLConnection)url.openConnection()).getJarFile();
                result.addAll(ClassHelper.getClassInJar(jar, path, packName));
            }
            classes = result;
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException("\u83b7\u53d6\u5305\u9519\u8bef\uff1a" + path);
        }
    }

    private static List<Class<?>> getClassInJar(JarFile jar, String packageDirName, String packageName) {
        ArrayList result = new ArrayList();
        try {
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                int idx;
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (name.charAt(0) == '/') {
                    name = name.substring(1);
                }
                if (!name.startsWith(packageDirName) || !name.endsWith(".class") || (idx = name.lastIndexOf(47)) == -1 || !name.endsWith(".class")) continue;
                String className = name.substring(packageName.length() + 1, name.length() - 6);
                result.add(Class.forName(packageName + '.' + className));
            }
            return result;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<Class<?>> getClassInPath(String packName, String filePath) {
        ArrayList result = new ArrayList();
        File dir = new File(filePath);
        File[] dirfiles = dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(".class");
            }
        });
        try {
            for (File file : dirfiles) {
                String className = file.getName().substring(0, file.getName().length() - 6);
                Class<?> c = Class.forName(packName + "." + className);
                result.add(c);
            }
            return result;
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

