/*
 * Decompiled with CFR 0.152.
 */
package com.af.path;

import com.af.path.Delegate;
import com.af.path.ExpressionException;
import com.af.path.ExpressionType;
import com.af.path.SubQuery;
import com.af.path.SumSubQuery;
import java.util.ArrayList;
import java.util.List;

public class Expression {
    public ExpressionType type;
    public Object value;
    public List<Expression> children = new ArrayList<Expression>();
    public Delegate delegate;
    private String source;
    private int pos;

    private Expression(ExpressionType type, String source, int pos) {
        this.type = type;
        this.source = source;
        this.pos = pos;
    }

    private Expression(ExpressionType type, Object value, String source, int pos) {
        this.type = type;
        this.value = value;
        this.source = source;
        this.pos = pos;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int level) {
        String result = this.space(level) + "type: " + (Object)((Object)this.type) + ", value: " + (this.value != null ? this.value.toString() : "null") + "[\n";
        for (Expression child : this.children) {
            result = result + (child != null ? child.toString(level + 1) : this.space(level + 1) + "null\n");
        }
        result = result + this.space(level) + "]\n";
        return result;
    }

    private String space(int n) {
        String result = "";
        for (int i = 0; i < n; ++i) {
            result = result + "    ";
        }
        return result;
    }

    public Delegate Compile() {
        Delegate result = new Delegate(this);
        return result;
    }

    public Object invoke(SubQuery parent) {
        try {
            switch (this.type) {
                case Path: {
                    return this.path(parent);
                }
                case TypeLimit: {
                    this.typeLimit(parent);
                    return null;
                }
                case Alias: {
                    this.alias(parent);
                    return null;
                }
                case And: 
                case Or: 
                case In: 
                case Like: 
                case GreaterThan: 
                case GreaterThanOrEqual: 
                case LessThan: 
                case LessThanOrEqual: 
                case Equal: 
                case NotEqual: 
                case Add: 
                case Subtract: 
                case Multiply: 
                case Divide: 
                case Modulo: {
                    return this.twoOperator(parent);
                }
                case Condition: {
                    this.condition(parent);
                    return null;
                }
                case Group: {
                    this.group(parent);
                    return null;
                }
                case Identy: {
                    return this.identy(parent);
                }
                case Const: {
                    return this.con(parent);
                }
                case Method: {
                    return this.method(parent);
                }
                case Property: {
                    return this.property(parent);
                }
                case Array: {
                    return this.array(parent);
                }
            }
            throw new RuntimeException("\u65e0\u6548\u64cd\u4f5c!" + (Object)((Object)this.type));
        }
        catch (ExpressionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExpressionException(this.source, this.pos, ex);
        }
    }

    public Object invoke2(SubQuery parent) {
        try {
            switch (this.type) {
                case Path: {
                    return this.path2(parent);
                }
                case TypeLimit: {
                    this.typeLimit2(parent);
                    return null;
                }
                case And: 
                case Or: 
                case In: 
                case Like: 
                case GreaterThan: 
                case GreaterThanOrEqual: 
                case LessThan: 
                case LessThanOrEqual: 
                case Equal: 
                case NotEqual: 
                case Add: 
                case Subtract: 
                case Multiply: 
                case Divide: 
                case Modulo: {
                    return this.twoOperator2(parent);
                }
                case Array: {
                    return this.array(parent);
                }
                case Identy: {
                    return this.identy2(parent);
                }
                case Const: {
                    return this.con2(parent);
                }
                case Method: {
                    return this.method2(parent);
                }
                case Property: {
                    return this.property2(parent);
                }
            }
            throw new RuntimeException("\u65e0\u6548\u64cd\u4f5c!" + (Object)((Object)this.type));
        }
        catch (ExpressionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExpressionException(this.source, this.pos, ex);
        }
    }

    private String con2(SubQuery parent) {
        if (this.value == null) {
            return null;
        }
        if (this.value instanceof String) {
            return "'" + this.value + "'";
        }
        return this.value.toString();
    }

    private String con(SubQuery parent) {
        if (this.value == null) {
            return null;
        }
        if (this.value instanceof String) {
            return "'" + this.value + "'";
        }
        return this.value.toString();
    }

    private String identy2(SubQuery parent) {
        String name = (String)this.value;
        if (parent == this.delegate.queries.peek()) {
            String[] strs = name.split(":");
            if (strs.length == 2) {
                name = strs[1];
            }
            return name;
        }
        return parent.getFieldName(name);
    }

    private String identy(SubQuery parent) {
        String name = (String)this.value;
        String[] strs = name.split(":");
        if (strs.length == 2) {
            parent.tableName = strs[0];
            name = strs[1];
        }
        return name;
    }

    private SubQuery path2(SubQuery parent) {
        SubQuery query = parent.getSubQuery(this);
        return query;
    }

    private SubQuery path(SubQuery parent) {
        String name = (String)this.value;
        if (parent == null) {
            throw new RuntimeException("\u65e0\u6cd5\u53d6\u5b50\u67e5\u8be2\uff0c\u7236\u4e3a\u7a7a!" + name);
        }
        SubQuery query = parent.createSubQuery(name, this);
        for (Expression expression : this.children) {
            expression.invoke(query);
        }
        return query;
    }

    private String typeLimit2(SubQuery query) {
        return null;
    }

    private SubQuery typeLimit(SubQuery query) {
        SubQuery parent = query.toUnionSubQuery();
        List types = (List)this.value;
        for (String type : types) {
            SubQuery sub = parent.createLimitSubQuery(query.entity, type);
            for (Expression child : this.children) {
                child.invoke(sub);
            }
        }
        return parent;
    }

    private void alias(SubQuery parent) {
        String name = (String)this.value;
        Expression exp = this.children.get(0);
        Object obj = exp.invoke(parent);
        if (exp.type == ExpressionType.Path) {
            parent.addField(name, obj, null);
            return;
        }
        String str = (String)obj;
        if (exp.type == ExpressionType.Const || exp.type == ExpressionType.Identy) {
            if (this.value != null && this.value.equals("**")) {
                parent.addAllFields(true);
            } else if (this.value != null && this.value.equals("*")) {
                parent.addAllFields(false);
            } else {
                parent.addField(name, str, exp.type);
            }
            return;
        }
        if (exp.type == ExpressionType.Method && (exp.value.equals("group") || exp.value.equals("order"))) {
            return;
        }
        parent.addField(name, exp, null);
    }

    private String twoOperator2(SubQuery query) {
        Expression left = this.children.get(0);
        Expression right = this.children.get(1);
        String oLeft = (String)left.invoke2(query);
        String oRight = (String)right.invoke2(query);
        switch (this.type) {
            case Like: {
                return oLeft + " like " + oRight;
            }
            case In: {
                return oLeft + " in " + oRight;
            }
            case And: {
                return oLeft + " and " + oRight;
            }
            case Or: {
                return oLeft + " or " + oRight;
            }
            case Add: {
                return oLeft + "+" + oRight;
            }
            case Subtract: {
                return oLeft + "-" + oRight;
            }
            case Multiply: {
                return oLeft + "*" + oRight;
            }
            case Divide: {
                return oLeft + "/" + oRight;
            }
            case Modulo: {
                return oLeft + "%" + oRight;
            }
            case GreaterThan: {
                return oLeft + ">" + oRight;
            }
            case GreaterThanOrEqual: {
                return oLeft + ">=" + oRight;
            }
            case LessThan: {
                return oLeft + "<" + oRight;
            }
            case LessThanOrEqual: {
                return oLeft + "<=" + oRight;
            }
            case Equal: {
                if (oRight == null) {
                    return oLeft + " is null ";
                }
                return oLeft + "=" + oRight;
            }
            case NotEqual: {
                if (oRight == null) {
                    return oLeft + " is not null ";
                }
                return oLeft + "!=" + oRight;
            }
        }
        throw new RuntimeException("\u4e0d\u8bc6\u522b\u7684\u7b97\u6570\u64cd\u4f5c\u7b26");
    }

    private String array(SubQuery query) {
        String result = "(";
        for (Expression exp : this.children) {
            if (!result.equals("(")) {
                result = result + ",";
            }
            result = result + exp.invoke(query);
        }
        result = result + ")";
        return result;
    }

    private String twoOperator(SubQuery query) {
        Expression left = this.children.get(0);
        Expression right = this.children.get(1);
        String oLeft = (String)left.invoke(query);
        String oRight = (String)right.invoke(query);
        switch (this.type) {
            case Like: {
                return oLeft + " like " + oRight;
            }
            case In: {
                return oLeft + " in " + oRight;
            }
            case And: {
                return oLeft + " and " + oRight;
            }
            case Or: {
                return oLeft + " or " + oRight;
            }
            case Add: {
                return oLeft + "+" + oRight;
            }
            case Subtract: {
                return oLeft + "-" + oRight;
            }
            case Multiply: {
                return oLeft + "*" + oRight;
            }
            case Divide: {
                return oLeft + "/" + oRight;
            }
            case Modulo: {
                return oLeft + "%" + oRight;
            }
            case GreaterThan: {
                return oLeft + ">" + oRight;
            }
            case GreaterThanOrEqual: {
                return oLeft + ">=" + oRight;
            }
            case LessThan: {
                return oLeft + "<" + oRight;
            }
            case LessThanOrEqual: {
                return oLeft + "<=" + oRight;
            }
            case Equal: {
                if (oRight == null) {
                    return oLeft + " is null ";
                }
                return oLeft + "=" + oRight;
            }
            case NotEqual: {
                if (oRight == null) {
                    return oLeft + " is not null ";
                }
                return oLeft + "!=" + oRight;
            }
        }
        throw new RuntimeException("\u4e0d\u8bc6\u522b\u7684\u7b97\u6570\u64cd\u4f5c\u7b26");
    }

    private String method2(SubQuery query) {
        String result;
        String name = (String)this.value;
        Expression objExp = this.children.get(0);
        if (objExp != null && objExp.children.size() == 1) {
            Expression child = objExp.children.get(0);
            if (child.type == ExpressionType.Path) {
                objExp = child;
            }
        }
        if (objExp != null && query.exp != objExp) {
            query = (SubQuery)objExp.invoke2(query);
        } else if (this.isAggragate(name) && !(query instanceof SumSubQuery)) {
            query = query.arragateSub;
        }
        if (this.delegate.queries.peek() != query) {
            result = query.getFieldName(this);
            return result;
        }
        result = name + "(";
        String params = "";
        for (Expression expression : this.children.subList(1, this.children.size())) {
            expression.delegate.queries.push(query);
            String param = (String)expression.invoke2(query);
            expression.delegate.queries.pop();
            if (!params.equals("")) {
                params = params + ",";
            }
            params = params + param;
        }
        result = result + params + ")";
        return result;
    }

    private String property2(SubQuery query) {
        String name = (String)this.value;
        Expression objExp = this.children.get(0);
        query = (SubQuery)objExp.invoke2(query);
        while (query.children.size() > 0) {
            query = query.children.get(0);
        }
        return query.getFieldName(name);
    }

    private String property(SubQuery query) {
        String name = (String)this.value;
        Expression objExp = this.children.get(0);
        query = (SubQuery)objExp.invoke(query);
        while (query.children.size() > 0) {
            query = query.children.get(0);
        }
        query.addField(name, name, ExpressionType.Identy);
        return null;
    }

    private String method(SubQuery query) {
        String name = (String)this.value;
        if (name.equals("order")) {
            return this.order(query);
        }
        if (this.isAggragate(name)) {
            Expression objExp = this.children.get(0);
            if (objExp != null) {
                query = (SubQuery)objExp.invoke(query);
                while (query.children.size() > 0) {
                    query = query.children.get(0);
                }
            }
            SumSubQuery sub = query.getAggragateQuery();
            sub.addField(this);
            query = sub;
        }
        String result = name + "(";
        String params = "";
        for (Expression expression : this.children.subList(1, this.children.size())) {
            String param = (String)expression.invoke(query);
            if (!params.equals("")) {
                params = params + ",";
            }
            params = params + param;
        }
        result = result + params + ")";
        return result;
    }

    private void group(SubQuery parent) {
        SumSubQuery sum = parent.getAggragateQuery();
        for (Expression expression : this.children) {
            expression.invoke(parent);
            sum.groups.add(expression.children.get(0));
        }
        parent.fields.remove(null);
    }

    private String order(SubQuery parent) {
        for (Expression expression : this.children.subList(1, this.children.size())) {
            expression.invoke(parent);
            parent.orders.add(expression);
        }
        return "";
    }

    private void condition(SubQuery parent) {
        SubQuery sub = parent.createConditionSub();
        Expression exp = this.children.get(0);
        exp.invoke(sub);
        sub.conditions.add(exp);
    }

    private boolean isAggragate(String name) {
        String[] names;
        for (String s : names = new String[]{"sum", "count", "min", "max", "avg"}) {
            if (!s.equals(name)) continue;
            return true;
        }
        return false;
    }

    public static Expression PathList(List<Expression> paths, String source, int pos) {
        Expression result = new Expression(ExpressionType.PathList, null, source, pos);
        result.children = paths;
        return result;
    }

    public static Expression Path(Object value, List<Expression> attrList, List<Expression> conditions, String source, int pos) {
        Expression result = new Expression(ExpressionType.Path, value, source, pos);
        result.children = attrList;
        result.children.addAll(conditions);
        return result;
    }

    public static Expression Path(Object value, List<Expression> conditions, String source, int pos) {
        Expression result = new Expression(ExpressionType.Path, value, source, pos);
        result.children = conditions;
        return result;
    }

    public static Expression Condition(Expression value, String source, int pos) {
        Expression result = new Expression(ExpressionType.Condition, null, source, pos);
        result.children.add(value);
        return result;
    }

    public static Expression Alias(Expression exp, String name, String source, int pos) {
        Expression result = new Expression(ExpressionType.Alias, name, source, pos);
        if (exp != null) {
            result.children.add(exp);
        }
        return result;
    }

    public static Expression Identy(String value, String source, int pos) {
        Expression result = new Expression(ExpressionType.Identy, value, source, pos);
        return result;
    }

    public static Expression Const(Object value, String source, int pos) {
        Expression result = new Expression(ExpressionType.Const, value, source, pos);
        return result;
    }

    public static Expression OneOperator(ExpressionType type, Expression value, String source, int pos) {
        Expression result = new Expression(type, value, source, pos);
        return result;
    }

    public static Expression TwoOperator(ExpressionType type, Expression left, Expression right, String source, int pos) {
        Expression result = new Expression(type, null, source, pos);
        result.children.add(left);
        result.children.add(right);
        return result;
    }

    public static Expression Method(String name, Expression object, List<Expression> params, String source, int pos) {
        Expression result = new Expression(ExpressionType.Method, name, source, pos);
        result.children.add(object);
        result.children.addAll(params);
        return result;
    }

    public static Expression Property(String name, Expression object, List<Expression> conditions, String source, int pos) {
        Expression result = new Expression(ExpressionType.Property, name, source, pos);
        result.children.add(object);
        result.children.addAll(conditions);
        return result;
    }

    public static Expression TypeLimit(List<String> names, List<Expression> attrs, String source, int pos) {
        Expression result = new Expression(ExpressionType.TypeLimit, names, source, pos);
        result.children = attrs;
        return result;
    }

    public static Expression Group(List<Expression> alias, String source, int pos) {
        Expression result = new Expression(ExpressionType.Group, null, source, pos);
        result.children = alias;
        return result;
    }

    public static Expression Array(List<Expression> array, String source, int pos) {
        Expression result = new Expression(ExpressionType.Array, null, source, pos);
        result.children = array;
        return result;
    }
}

