package com.aote.rs;

import org.json.JSONArray;
import org.json.JSONObject;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Iterator;

public class OrgCondition {
    public static String getcondition(JSONObject json){
        StringBuffer sbs = new StringBuffer();
        if(json == null){
            return "";
        }
        Iterator<String> iterator = json.keys();
        while(iterator.hasNext()){
            String next = iterator.next();
            if(next.equals("items")){
                continue;
            }
            sbs.append(next);
            if(next.toLowerCase().equals("startdate")){
                sbs.append(">=");
            }else if(next.toLowerCase().equals("enddate")){
                sbs.append("<=");
            }else{
                sbs.append("=");
            }
            if(json.get(next) instanceof Integer || json.get(next) instanceof Float){
                sbs.append(json.get(next));
            }else{
                sbs.append("'"+json.get(next)+"'");
            }
            if(iterator.hasNext()){
                sbs.append(" and ");
            }
        }
        return sbs.toString();
    }

    /**
     * 处理插件处理不了的数据，进行转换
     * @param json
     * @return
     */
    public static JSONArray getJudgeArray(JSONArray json){
        if(json == null) return  null;
        JSONArray newarray = new JSONArray();
        for(int i=0; i<json.length();i++){
            JSONObject map = (JSONObject) json.get(i);
            JSONObject newobject = new JSONObject();
            Iterator<String> it = map.keys();
            while(it.hasNext()){
                String next = it.next();
                Object o = map.get(next);
                if(map.get(next) instanceof BigInteger){
                    newobject.put(next,Integer.valueOf(map.get(next).toString()));
                }else if(map.isNull(next)){
                    newobject.put(next,"");
                }else if(map.get(next) instanceof BigDecimal){
                    newobject.put(next,map.get(next).toString());
                }else if(map.get(next) instanceof Timestamp){
                    newobject.put(next,new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(map.get(next)));
                }else{
                    newobject.put(next,map.get(next));
                }
            }
            newarray.put(newobject);
        }
        return newarray;
    }

}
