SELECT f_user_type f_gasproperties_type,
	f_gasproperties,
	SUM (newadduser) newadduser,
	SUM (ACCOUNT) ACCOUNT,
	SUM (startuser) startuser,
	SUM (stopuser) stopuser,
	SUM (nowuser) nowuser
FROM
	(
		--查询时间段内新增用户数
		SELECT
			f.f_user_type,
			f.f_gasproperties,
			0 beforeuser,
			COUNT (u.f_userinfo_id) newadduser,
			0 ACCOUNT,
			0 startuser,
			0 stopuser,
			0 nowuser
		FROM
			t_userfiles f
			left join t_userinfo u on u.f_userinfo_id = f.f_userinfo_id
		WHERE
			u.f_user_state = '正常'
		AND f_input_date >= '{startDate} 00:00:00'
		AND f_input_date <= '{endDate} 23:59:59'
		AND f.f_user_type IS NOT NULL
		AND f.f_gasproperties IS NOT NULL
		and { 		filialeCodeStr != $$:
        $
          f.f_orgstr like '{filialeCodeStr}%'
        $,
        filialeCodeStr == $$:
        $
        	1=1
        $,
        $$
			} and
			{		filiale != $$:
			       $
			         f.f_filiale='{filiale}'
			       $,
			       filiale == $$:
			       $
			         1=1
			       $,
			       $$
			}
		GROUP BY
			f.f_user_type,
			f.f_gasproperties
		UNION ALL
			--查询时间段内销户用户数
			SELECT
				f.f_user_type,
				f.f_gasproperties,
				0 beforeuser,
				0 newadduser,
				COUNT (T . ID) ACCOUNT,
				0 startuser,
				0 stopuser,
				0 nowuser
			FROM
				t_cancellation T
			left join t_userfiles f on f.f_userinfo_id = T.f_userinfo_id
			WHERE
				T .f_cancel_state = '销户'
			AND T .f_operate_date >= '{startDate} 00:00:00'
			AND T .f_operate_date <= '{endDate} 23:59:59'
			AND f.f_user_type IS NOT NULL
			AND f.f_gasproperties IS NOT NULL
			and { 		filialeCodeStr != $$:
        $
          f.f_orgstr like '{filialeCodeStr}%'
        $,
        filialeCodeStr == $$:
        $
        	1=1
        $,
        $$
			} and
			{		filiale != $$:
			       $
			         f.f_filiale='{filiale}'
			       $,
			       filiale == $$:
			       $
			         1=1
			       $,
			       $$
			}
			GROUP BY
				f.f_user_type,
				f.f_gasproperties
			UNION ALL
				--查询时间段内启用的用户数
				SELECT
					f.f_user_type,
					f.f_gasproperties,
					0 beforeuser,
					0 newadduser,
					0 ACCOUNT,
					COUNT (T . ID) startuser,
					0 stopuser,
					0 nowuser
				FROM
					t_enable T
				left join t_userfiles f on T .f_userinfo_id = f.f_userinfo_id
				WHERE
					T .f_operate_date >= '{startDate} 00:00:00'
				AND T .f_operate_date <= '{endDate} 23:59:59'
				AND f.f_user_type IS NOT NULL
				AND f.f_gasproperties IS NOT NULL
			and { 		filialeCodeStr != $$:
        $
          f.f_orgstr like '{filialeCodeStr}%'
        $,
        filialeCodeStr == $$:
        $
        	1=1
        $,
        $$
			} and
			{		filiale != $$:
			       $
			         f.f_filiale='{filiale}'
			       $,
			       filiale == $$:
			       $
			         1=1
			       $,
			       $$
			}
				GROUP BY
					f.f_user_type,
					f.f_gasproperties
				UNION ALL
					--查询时间段内停用的用户数
					SELECT
						f.f_user_type,
						f.f_gasproperties,
						0 beforeuser,
						0 newadduser,
						0 ACCOUNT,
						0 startuser,
						COUNT (T . ID) stopuser,
						0 nowuser
					FROM
						t_disable T
					left join t_userfiles f on T .f_userinfo_id = f.f_userinfo_id
					WHERE
						T .f_operate_date >= '{startDate} 00:00:00'
					AND T .f_operate_date <= '{endDate} 23:59:59'
					AND f.f_user_type IS NOT NULL
					AND f.f_gasproperties IS NOT NULL
								and { 		filialeCodeStr != $$:
        $
          f.f_orgstr like '{filialeCodeStr}%'
        $,
        filialeCodeStr == $$:
        $
        	1=1
        $,
        $$
			} and
			{		filiale != $$:
			       $
			         f.f_filiale='{filiale}'
			       $,
			       filiale == $$:
			       $
			         1=1
			       $,
			       $$
			}
					GROUP BY
						f.f_user_type,
						f.f_gasproperties
	) s
GROUP BY
	f_user_type,
	f_gasproperties
