//查询用气类型
SELECT
	isnull (
		f_meter_type,
		'f_meter_type'
	) f_meter_type,
	isnull (
		s.f_user_type,
		'f_user_type'
	) f_user_type,
	isnull (
		s.f_gasproperties,
		'f_gasproperties'
	) f_gasproperties,
	isnull (
		sp.f_price_name,
		'f_price_name'
	) f_price_name,
	c.f_price_name + '(' + CAST (c.f_price AS VARCHAR) + ')' f_price,
	SUM (c.f_gas) f_gas,
	SUM (f_money) f_money
FROM
	t_chargeprice c
LEFT JOIN t_sellinggas s ON c.f_charge_id = s. ID
LEFT JOIN t_stairprice sp ON s.f_stairprice_id = sp. ID
WHERE
	f_charge_id IN (
		SELECT
			ID
		FROM
			t_sellinggas s
		WHERE
			f_delivery_date >= '{startDate}'
		AND f_delivery_date <= '{endDate}'
		AND 			{ 		filialeCodeStr != $$:
        $
          f_orgstr like '{filialeCodeStr}%'
        $,
        filialeCodeStr == $$:
        $
        	1=1
        $,
        $$
			} and
			{		filiale != $$:
			       $
			         f_filiale='{filiale}'
			       $,
			       filiale == $$:
			       $
			         1=1
			       $,
			       $$
			}
AND f_charge_state = '有效'
	)
GROUP BY
	f_meter_type,
	s.f_user_type,
	s.f_gasproperties,
	sp.f_price_name,
	c.f_price_name,
	c.f_price