select
  *
from (
select
 u.f_meternumber,   --表钢号
 uf.f_userinfo_code, --用户编号
 uf.f_user_name,	--用户姓名
 a.f_address,		--用户地址
 u.f_gas_date,		--开户日期
 u.f_user_type,		--用户类型
 u.f_gasproperties, --用气类型
 u.f_gasproperties2, --用气属性
 case when s.max_days is null
 then  (case
	when DATEDIFF(day, u.f_gas_date,'{endDate}')<0 then 0
	when DATEDIFF(day, u.f_gas_date,'{startDate}')>=0 then DATEDIFF(day, '{startDate}','{endDate}')+1
	else DATEDIFF(day, u.f_gas_date,'{endDate}')+1
	end) else s.max_days end max_days,		--最长失联天数
 case when s.all_days is null
 then  (case
	when DATEDIFF(day, u.f_gas_date,'{endDate}')<0 then 0
	when DATEDIFF(day, u.f_gas_date,'{startDate}')>=0 then DATEDIFF(day, '{startDate}','{endDate}')+1
	else DATEDIFF(day, u.f_gas_date,'{endDate}')+1
	end) else s.all_days end all_days ,		--合计失联天数
 s.min_insert_date,	--期初上报日期
 s.max_insert_date,	--期末上报日期
 isnull(s.c,0) c,				--期间上报次数
 case
  when  max_days is null then '期间未上报'
  when  max_days>0 and max_days<5 then '5天之内'
  when  max_days>=5 and max_days<7 then '5-7天'
  when  max_days>=7 and max_days<15 then '7-15天'
  when  max_days>=15 and max_days<30 then '15-30天'
  when  max_days>=30 and max_days<60  then '30-60天'
  else  '60天以上' end  max_days_type,  --最长失联天数类型
 case
  when  all_days is null then '期间未上报'
  when  all_days>0 and all_days<5 then '5天之内'
  when  all_days>=5 and all_days<7 then '5-7天'
  when  all_days>=7 and all_days<15 then '7-15天'
  when  all_days>=15 and all_days<30 then '15-30天'
  when  all_days>=30 and all_days<60  then '30-60天'
  else  '60天以上' end  all_days_type,  --合计失联天数类型
	  u.f_orgid,
	  u.f_orgname,
    u.f_depid,
    u.f_depname
from
 t_userfiles u
 left join t_userinfo uf on u.f_userinfo_id=uf.f_userinfo_id
 left join t_user_address a on uf.f_userinfo_id = a.f_userinfo_id
 left join
(
	--查询用户失联情况
	select
		s.f_user_id,	--表编号
		f_userinfo_id, --用户编号
		s.f_meternumber, --表号
		f_gas_date, --开户日期
		case when DATEDIFF(day, max(f_insert_date),'{endDate}')>max(days) then
		 DATEDIFF(day, max(f_insert_date),'{endDate}')
		 else max(days)-1 end max_days,
		 --最长失联天数
		sum(days) - count(*) +
			case when DATEDIFF(day, max(f_insert_date),'{endDate}')>1
			then DATEDIFF(day, max(f_insert_date),'{endDate}') else 0 end  all_days, --合计失联天数
		min(f_insert_date) min_insert_date, --首次上报日期
		max(f_insert_date) max_insert_date, --最后上报日期
		count(*) c --合计上报次数
	from(
		select
			 f_user_id,
			 f_userinfo_id,
			 f_meternumber,
			 convert(varchar(100),f_gas_date,20) f_gas_date,
			 f_insert_date,
			 f_last_insertdate,
			 case when f_last_insertdate is null then 1 else
			 (case when DATEDIFF(day, (case when f_last_insertdate>='{startDate}' then f_last_insertdate else '{startDate}' end), f_insert_date)=0 then 1
			 else DATEDIFF(day, (case when f_last_insertdate>='{startDate}'then f_last_insertdate else '{startDate}' end), f_insert_date) end) end days
		from t_meteread
		where f_insert_date>='{startDate}' and f_insert_date<='{endDate}'
	) s
	group by s.f_user_id,f_userinfo_id,s.f_meternumber,f_gas_date
) s  on u.f_user_id=s.f_user_id and s.f_meternumber=u.f_meternumber
where u.f_gas_date<='{endDate}' and u.f_table_state='正常' and uf.f_user_state='正常'
and (max_days>0 or max_days is null) and {condition}
) s
order by max_days,f_gas_date