--失联数据汇总查询

select
	*
from(
	select
	 {groupname},
	 --u.f_user_type '用户类型', --汇总分类1
	-- u.f_gasproperties '用气性质',		--汇总分类2
	 --u.f_orgstr,			--汇总分类3
	 u.f_meternumber,		--表钢号
	 case
	  when  max_days is null then '_one'
	  when  max_days>0 and max_days<5 then '_five'
	  when  max_days>=5 and max_days<7 then 'five_seven'
	  when  max_days>=7 and max_days<15 then 'seven_fifteen'
	  when  max_days>=15 and max_days<30 then 'fifteen_thirty'
	  when  max_days>=30 and max_days<60  then 'thirty_sixty'
	  else  'sixty_' end  max_days_type  --最长失联天数类型
	from
	 t_userfiles u
	 left join t_userinfo uf on u.f_userinfo_id=uf.f_userinfo_id
	 left join
	(
		--查询用户失联情况
		select
			s.f_user_id,	--表编号
			f_userinfo_id, --用户编号
			s.f_meternumber, --表号
			f_gas_date, --开户日期
			case when DATEDIFF(day, max(f_insert_date),'{endDate}')>max(days)  then
			 DATEDIFF(day, max(f_insert_date),'{endDate}')
			 else max(days)-1 end max_days,  --最长失联天数
			sum(days)-count(*)+
			case when DATEDIFF(day, max(f_insert_date),'{endDate}')>1
			then DATEDIFF(day, max(f_insert_date),'{endDate}') else 0 end  all_days, --合计失联天数
			min(f_insert_date) min_insert_date, --首次上报日期
			max(f_insert_date) max_insert_date, --最后上报日期
			count(*) c --合计上报次数
		from(
			select
				 f_user_id,
				 f_userinfo_id,
				 f_meternumber,
				 convert(varchar(100),f_gas_date,20) f_gas_date,
				 f_insert_date,
				 f_last_insertdate,
				 case when f_last_insertdate is null then 1 else
				 (case when DATEDIFF(day, (case when f_last_insertdate>='{startDate}' then f_last_insertdate else '{startDate}' end), f_insert_date)=0 then 1
				 else DATEDIFF(day, (case when f_last_insertdate>='{startDate}'then f_last_insertdate else '{startDate}' end), f_insert_date) end) end days
			from t_meteread
			where f_insert_date>='{startDate}' and f_insert_date<='{endDate}'
		) s
		group by s.f_user_id,f_userinfo_id,s.f_meternumber,convert(varchar(100),f_gas_date,20)
	) s  on u.f_user_id=s.f_user_id and s.f_meternumber=u.f_meternumber
	where u.f_gas_date<='{endDate}' and u.f_table_state='正常' and uf.f_user_state='正常'
	and (max_days>0 or max_days is null) and {condition}
) s pivot(count(f_meternumber) for max_days_type in ([_one],[_five],[five_seven],[seven_fifteen],[fifteen_thirty],[thirty_sixty],[sixty_])) as t