select f_date,f_total_user,f_total_meter,f_civil_gas,
f_nocivil_gas,f_nocontact_total,f_meteread_total, f_instruction_success,
f_instruction_total,f_untreated_sign,f_sign_total,f_abnormal_total
from (
SELECT
{groupname} f_date,
AVG(f_total_user) f_total_user,
AVG(f_total_meter) f_total_meter,
sum(f_civil_gas) f_civil_gas,
sum(f_nocivil_gas) f_nocivil_gas,
sum(f_nocontact_total) f_nocontact_total,
sum(f_meteread_total) f_meteread_total,
sum(f_instruction_success) f_instruction_success,
sum(f_instruction_total) f_instruction_total,
sum(f_untreated_sign) f_untreated_sign,
sum(f_sign_total) f_sign_total,
sum(f_abnormal_total) f_abnormal_total
from (
    SELECT
	    f_total_user,
        f_total_meter,
        f_civil_gas,
        f_nocivil_gas,
        f_nocontact_total,
        f_meteread_total,
        f_instruction_success,
        f_instruction_total,
        f_untreated_sign,
        f_sign_total,
        f_abnormal_total,
        convert(varchar(4),i.f_date,23)+'年' year,
		convert(varchar(7),i.f_date,23) month,
		cast(Datename(week,i.f_date) as varchar)+'周'  week,
		convert(varchar(50),i.f_date,23) day
    FROM
    t_indicator_statistics as i
    where f_date>='{startDate}' and f_date<='{endDate}' and {condition}
    GROUP BY f_date,f_total_user,f_total_meter,f_civil_gas,f_nocivil_gas,f_nocontact_total,
    f_meteread_total,f_instruction_success,f_instruction_total,f_untreated_sign,f_sign_total,
    f_abnormal_total
) t
GROUP BY {groupname}) p
ORDER BY f_date