select * FROM(
	SELECT
		SUM(s) t,                        --异常总数
		SUM(type1) type1,                --拆表上报
		SUM(type2) type2,                --补抄上报
		SUM(type3) type3,                --锂电低电上报
		SUM(type4) type4,                --E7上报
		SUM(type5) type5,                --E8上报
		SUM(type6) type6,                --E16上报
		SUM(type7) type7,                --E21上报
		SUM(type8) type8,                --E23上报
		SUM(type9) type9,                --其他上报
		{groupname}
	FROM(
		SELECT 1 s,
			convert(varchar(4),e.f_insert_date,23)+'年' year,
			convert(varchar(7),e.f_insert_date,23) month,
			cast(Datename(week,e.f_insert_date) as varchar)+'周'  week,
			convert(varchar(50),e.f_insert_date,23) day,
			case when e.f_upload_type='拆表上报' then 1 else 0 end type1,
			case when e.f_upload_type='补抄上报' then 1 else 0 end type2,
			case when e.f_upload_type='锂电低电上报' then 1 else 0 end type3,
			case when e.f_upload_type='E7上报' then 1 else 0 end type4,
			case when e.f_upload_type='E8上报' then 1 else 0 end type5,
			case when e.f_upload_type='E16上报' then 1 else 0 end type6,
			case when e.f_upload_type='E21上报' then 1 else 0 end type7,
			case when e.f_upload_type='E23上报' then 1 else 0 end type8,
			case when e.f_upload_type='其他上报' then 1 else 0 end type9,
			u.f_orgstr,f.f_user_type,f.f_gasproperties,f.f_gasproperties2
		FROM t_meteread e
		LEFT JOIN t_userfiles f on f.f_user_id=e.f_user_id
		LEFT JOIN t_userinfo u on u.f_userinfo_id=f.f_userinfo_id
		where e.f_upload_type in('拆表上报','补抄上报','锂电低电上报','E7上报','E8上报','E16上报','E21上报','E23上报','其他上报')
			and u.f_user_state='正常' and f.f_table_state='正常'
			and e.f_insert_date >= '{startDate}' and e.f_insert_date <= '{endDate}'
            and {condition}
		GROUP BY e.f_upload_type,u.f_orgstr,f.f_user_type,f.f_gasproperties,e.f_insert_date,f.f_gasproperties2
	) t
	GROUP BY {groupname}
) t
ORDER BY t