select
		  f_delivery_date f_delivery_date,  --日期
		  SUM(case when f_charge_type='发卡售气' then 1 else 0 end)  f_count_open, --发卡人数
		  SUM(case when f_charge_type='发卡售气' then f_pregas else 0 end)  f_pregas_open, --发卡气量
		  SUM(case when f_charge_type='发卡售气' then f_collection else 0 end)  f_collection_open, --发卡金额
		  SUM(case when f_charge_type not in ('补卡','发卡售气','补气','换表')  then 1 else 0 end)  f_count_zg, --再够人数
		  SUM(case when f_charge_type not in ('补卡','发卡售气','补气','换表')  then f_pregas else 0 end)  f_pregas_zg, --再够气量
		  SUM(case when f_charge_type not in ('补卡','发卡售气','补气','换表')  then f_collection else 0 end)  f_collection_zg, --再够金额
		  COUNT(1) f_count,         --总次数
		  SUM(f_pregas) f_pregas,         --总气量
		  SUM(f_collection) f_collection       --总金额
 from (
	select
	left(convert(varchar,f_delivery_date,21),7) f_delivery_date,
	f_charge_type,
	f_pregas,
	f_collection
	from
	t_sellinggas
	where   f_charge_state<>'无效'
	and year(f_delivery_date)= '{YeadDate}'
	and {condition}  --传组织
	union all
	SELECT
		left(convert(varchar,f_fillcard_date,21),7) f_delivery_date,
		'补卡' f_charge_type,
		0 f_pregas,
		f_cardfees f_collection
	FROM
		t_fillcard s
	where  f_fillcard_state<>'无效'
	and year(f_fillcard_date)= '{YeadDate}'
	and {condition}
	union all
	SELECT
		left(convert(varchar,f_changemeter_date,21),7)f_delivery_date,
		'换表' f_charge_type,
		0 f_pregas,
		f_changemeter_fee f_collection
	FROM
		t_changemeter s
	where  f_changemeter_state<>'无效'
	and year(f_changemeter_date)= '{YeadDate}'
	and {condition}
	union all
	SELECT
		left(convert(varchar,f_fillgas_date,21),7) f_delivery_date,
		'补气'  f_charge_type,
		f_fillgas  f_pregas,
		f_fillgas_fee  f_collection
	FROM
		t_fillgas s where f_fillgas_state<>'无效'
	and year(f_fillgas_date)= '{YeadDate}'
	and {condition}
) xx group by f_delivery_date order by f_delivery_date