select
    f_userinfo_code,
	f_user_name,
	f_address,
	f_meternumber,
	CONVERT(varchar(100), f_hand_date, 23) f_hand_date,
	max(f_input_date) f_input_date,
	min(f_last_tablebase) f_last_tablebase,
	max(f_tablebase) f_tablebase,
	sum(f_oughtamount) f_oughtamount,
	SUM(f_oughtfee) f_oughtfee,
	sum(f_stair1amount) f_stair1amount,
	sum(f_stair2amount) f_stair2amount,
	sum(f_stair3amount) f_stair3amount,
	SUM(f_stair1fee) f_stair1fee,
	SUM(f_stair2fee) f_stair2fee,
	SUM(f_stair3fee) f_stair3fee,
	SUM(f_haircut_gas) f_haircut_gas,
	sum(f_surplus_gas) f_surplus_gas,
	f_stair1price,
	f_stair2price,
	f_stair3price,
	f_inputtor,
	f_meter_state,
	f_hand_state,
	f_operatorid,
	f_operator,
	f_depid,
	f_depname,
	f_orgid,
	f_orgname

from (
select * from (
  select
    h.*,
    hd.f_stair1amount,hd.f_stair1price,hd.f_stair1fee,
    hd.f_stair2amount,hd.f_stair2price,hd.f_stair2fee,
    hd.f_stair3amount,hd.f_stair3price,hd.f_stair3fee
  from t_handplan h
  left join (
      select f_hand_id f_hand_id,
             sum(case f_price_name when '阶梯1' then f_gas  when '固定气价' then f_gas else 0 end) f_stair1amount,
             sum(case f_price_name when '阶梯1' then f_price when '固定气价' then f_price else 0 end) f_stair1price,
             sum(case f_price_name when '阶梯1' then f_money when '固定气价' then f_money else 0 end) f_stair1fee,
             sum(case f_price_name when '阶梯2' then f_gas else 0 end) f_stair2amount,
             sum(case f_price_name when '阶梯2' then f_price else 0 end) f_stair2price,
             sum(case f_price_name when '阶梯2' then f_money else 0 end) f_stair2fee,
             sum(case f_price_name when '阶梯3' then f_gas else 0 end) f_stair3amount,
             sum(case f_price_name when '阶梯3' then f_price else 0 end) f_stair3price,
             sum(case f_price_name when '阶梯3' then f_money else 0 end) f_stair3fee
      from t_chargeprice where f_hand_id is not null group by f_hand_id
    ) hd on hd.f_hand_id=h.id
) t
where {condition}
) t
group by f_userinfo_code,
	f_user_name,
	f_address,
	f_meternumber,
	CONVERT(varchar(100), f_hand_date, 23),
	f_stair1price,
	f_stair2price,
	f_stair3price,
	f_inputtor,
	f_meter_state,
	f_hand_state,
	f_operatorid,
	f_operator,
	f_depid,
	f_depname,
	f_orgid,
	f_orgname
order by  f_hand_date desc
