select * from (
select
	 u2.f_userinfo_code,
	 u2.f_user_name,
	 u1.f_user_type,
	 u1.f_gasproperties,
	 u2.f_user_state,
	 u3.f_address,
	 u1.f_meternumber,
	 u4.f_meter_type,
	 u1.f_user_id,
	 u1.f_table_state,
	 u4.f_meter_brand,
	 datediff(day,isnull(u5.delivery_date,u1.f_input_date),GETDATE())  diffday,
	 isnull(u5.delivery_date,u1.f_input_date) delivery_date,
	 isnull(u5.cishu,0) cishu,
	 isnull(u5.pregas,0) pregas,
	 isnull(u6.sellcishu,0) sellcishu,
	 isnull(u6.sellpregas,0) sellpregas,
	 u1.f_orgid,
	 u1.f_orgname
from t_userfiles u1
	left join
	t_userinfo u2 on u1.f_userinfo_id=u2.f_userinfo_id
left join t_user_address u3
on u1.f_useraddress_id=u3.id
left join t_gasbrand u4
on u1.f_gasbrand_id=u4.id
left join
	(
		select f_user_id,COUNT(1) cishu,SUM(f_oughtamount) pregas,MAX(f_input_date) delivery_date from t_handplan
		where f_meter_state='已抄表' and f_hand_state='有效'
		group by f_user_id
	) u5
 on u1.f_user_id=u5.f_user_id
left join
	(
		select f_user_id,COUNT(1) sellcishu,SUM(f_oughtamount) sellpregas,MAX(f_input_date) delivery_date from t_handplan
		where f_meter_state='已抄表' and f_hand_state='有效'
		 and  f_input_date  between {startDate} and {endDate}
		group by f_user_id
	) u6
on u1.f_user_id=u6.f_user_id where u4.f_meter_type='机表'
) ss where {condition} order by f_user_id