/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.inject.Singleton;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.hibernate.SQLQuery;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Path(value="BuySub")
@Singleton
@Component
public class BuySubService {
    @Autowired
    public SessionFactory sessionFactory;
    private Session buySession;
    private ScrollableResults buyResultset;
    BuySegment segment = new BuySegment();
    BigDecimal gasSum = new BigDecimal(0);
    BigDecimal handSum = new BigDecimal(0);

    public BigDecimal getAllGas(Date start, Date end) {
        BigDecimal result = new BigDecimal(0);
        Session session = this.sessionFactory.openSession();
        String sql = "select * from (\n\tselect f_user_id, to_date(to_char(f_delivery_date,'yyyy-mm-dd'),'yyyy-mm-dd') f_delivery_date, sum(f_pregas) f_pregas\n\t from t_sellinggas\n\tgroup BY f_user_id,f_delivery_date\n) t_gas\nORDER BY f_user_id, f_delivery_date";
        SQLQuery query = session.createSQLQuery(sql);
        ScrollableResults rs = query.scroll();
        String c_userId = "";
        BigDecimal c_sumNum = null;
        Date c_start = null;
        BigDecimal c_num = null;
        Date c_date = null;
        while (rs.next()) {
            BigDecimal gas;
            Object[] obj = rs.get();
            String userId = obj[0].toString();
            Date doDate = (Date)obj[1];
            BigDecimal num = (BigDecimal)obj[2];
            if (!userId.equals(c_userId)) {
                if (!c_userId.equals("") && c_date.compareTo(end) == -1) {
                    if (c_sumNum != null) {
                        gas = this.getRemainGas(c_start, c_sumNum, c_date, end);
                        result = result.add(gas);
                    } else {
                        gas = this.getRemainGas(c_date, end, new BigDecimal(2));
                        result = result.add(gas);
                    }
                }
                c_sumNum = null;
                c_start = doDate;
            } else {
                if (doDate.compareTo(start) >= 0 && c_date.compareTo(end) <= 0) {
                    gas = this.getBuyGas(start, end, c_date, doDate, c_num);
                    result = result.add(gas);
                }
                c_sumNum = c_sumNum == null ? num : c_sumNum.add(c_num);
            }
            c_userId = userId;
            c_num = num;
            c_date = doDate;
        }
        session.close();
        return result;
    }

    private BigDecimal getRemainGas(Date segEnd, Date end, BigDecimal val) {
        BigDecimal days = new BigDecimal(this.getSubDays(segEnd, end));
        BigDecimal result = val.multiply(days);
        return result;
    }

    private BigDecimal getRemainGas(Date start, BigDecimal sumGas, Date segEnd, Date end) {
        BigDecimal days = new BigDecimal(this.getSubDays(start, segEnd));
        BigDecimal aver = sumGas.divide(days, 2);
        days = new BigDecimal(this.getSubDays(segEnd, end));
        BigDecimal result = aver.multiply(days);
        return result;
    }

    @POST
    @Path(value="getFixedNum")
    public BigDecimal getFixedNum() {
        this.createBuyResultset();
        this.getInnerFiexdNum();
        this.closeBuySession();
        if (!this.handSum.equals(BigDecimal.ZERO)) {
            BigDecimal result = this.handSum.divide(this.gasSum, 4);
            return result;
        }
        return new BigDecimal(1);
    }

    public void getInnerFiexdNum() {
        Session session = this.sessionFactory.openSession();
        String sql = "select f_user_id, f_hand_date, f_tablebase\n from t_handplan\nORDER BY f_user_id, f_hand_date";
        SQLQuery query = session.createSQLQuery(sql);
        ScrollableResults rs = query.scroll();
        String c_userId = "";
        BigDecimal c_num = null;
        Date c_date = null;
        while (rs.next()) {
            Object[] obj = rs.get();
            String userId = obj[0].toString();
            Date doDate = (Date)obj[1];
            BigDecimal num = (BigDecimal)obj[2];
            if (!userId.equals(c_userId)) {
                c_userId = userId;
            } else {
                BigDecimal hand = num.subtract(c_num);
                this.addBuyGas(c_userId, c_date, doDate, hand);
            }
            c_num = num;
            c_date = doDate;
        }
        session.close();
    }

    private void queryRecord() {
        Session session = this.sessionFactory.openSession();
        String sql = "select f_user_id\nfrom t_handplan\nWHERE f_user_id IS NOT NULL\nGROUP by f_user_id";
        SQLQuery query = session.createSQLQuery(sql);
        ScrollableResults rs = query.scroll();
        while (rs.next()) {
            ScrollableResults rs5;
            Object[] obj = rs.get();
            String userId = obj[0].toString();
            sql = "SELECT t_userinfo.f_createfile_date\nFROM t_userinfo LEFT JOIN t_userfiles\nON t_userinfo.f_userinfo_id = t_userfiles.f_userinfo_id\nWHERE t_userfiles.f_user_id = '" + userId + "'";
            ScrollableResults rs1 = session.createSQLQuery(sql).scroll();
            rs1.next();
            Date cDate = (Date)rs1.get()[0];
            sql = "SELECT * FROM\n(SELECT\n\tf_hand_date\nFROM t_handplan WHERE\nf_user_id = '" + userId + "'\n" + "ORDER BY f_hand_date DESC)\n" + "WHERE rownum=1";
            ScrollableResults rs2 = session.createSQLQuery(sql).scroll();
            rs2.next();
            Date lDate = (Date)rs2.get()[0];
            String createDate = new SimpleDateFormat("yyyy-MM-dd").format(cDate);
            String lastDate = new SimpleDateFormat("yyyy-MM-dd").format(lDate);
            sql = "select nvl(sum(f_tablebase-f_last_tablebase),0) as gas from T_HANDPLAN \nwhere  f_user_id='" + userId + "' and f_hand_date >= to_date('" + createDate + "','yyyy-MM-dd')";
            ScrollableResults rs3 = session.createSQLQuery(sql).scroll();
            rs3.next();
            BigDecimal sumMeterBase = (BigDecimal)rs3.get()[0];
            this.handSum = this.handSum.add(sumMeterBase);
            BigDecimal sumPregas = new BigDecimal(0);
            sql = "SELECT f_pregas FROM t_sellinggas\nWHERE f_user_id = '" + userId + "' AND f_delivery_date = to_date('" + lastDate + "','yyyy-MM-dd') ";
            ScrollableResults rs4 = session.createSQLQuery(sql).scroll();
            if (rs4.next()) {
                sql = "SELECT sum(f_pregas) FROM t_sellinggas\nWHERE f_user_id = '" + userId + "' AND f_delivery_date >= to_date('" + createDate + "','yyyy-MM-dd')\n" + "AND f_delivery_date <= to_date('" + lastDate + "','yyyy-MM-dd hh24:mi:ss') ";
                rs5 = session.createSQLQuery(sql).scroll();
                rs5.next();
                sumPregas = (BigDecimal)rs5.get()[0];
            } else {
                Date afterDate;
                sql = "select * from \n(select to_date(to_char(f_delivery_date,'yyyy-mm-dd'),'yyyy-mm-dd') f_delivery_date,f_pregas\nfrom t_sellinggas\nwhere f_user_id=" + userId + "  AND f_delivery_date < to_date('" + lastDate + "','yyyy-MM-dd') \n" + "order by f_delivery_date desc)\n" + "where rownum=1\n" + "union ALL\n" + "select * from \n" + "(select to_date(to_char(f_delivery_date,'yyyy-mm-dd'),'yyyy-mm-dd') f_delivery_date,f_pregas\n" + "from t_sellinggas\n" + "where f_user_id=" + userId + "  AND f_delivery_date > to_date('" + lastDate + "','yyyy-MM-dd') \n" + "order by f_delivery_date)\n" + "where rownum=1";
                rs5 = session.createSQLQuery(sql).scroll();
                rs5.next();
                Date beforeDate = (Date)rs5.get()[0];
                BigDecimal beforePregas = (BigDecimal)rs5.get()[1];
                BigDecimal afterPregas = new BigDecimal(0);
                if (rs5.next()) {
                    afterDate = (Date)rs5.get()[0];
                    afterPregas = (BigDecimal)rs5.get()[1];
                } else {
                    afterDate = lDate;
                    afterPregas = beforePregas;
                }
                BigDecimal day1 = new BigDecimal(this.getSubDays(beforeDate, afterDate));
                BigDecimal day2 = new BigDecimal(this.getSubDays(beforeDate, lDate));
                BigDecimal smallPregas = afterPregas.divide(day1, 2, 4).multiply(day2);
                sql = "SELECT sum(f_pregas) FROM t_sellinggas\nWHERE f_user_id = '" + userId + "' AND f_delivery_date >= to_date('" + createDate + "','yyyy-MM-dd')\n" + "AND f_delivery_date <= to_date('" + new SimpleDateFormat("yyyy-MM-dd").format(beforeDate) + "','yyyy-MM-dd hh24:mi:ss') ";
                ScrollableResults rs6 = session.createSQLQuery(sql).scroll();
                rs6.next();
                BigDecimal mostPregas = (BigDecimal)rs6.get()[0];
                sumPregas = mostPregas.add(smallPregas);
            }
            this.gasSum = this.gasSum.add(sumPregas);
        }
        session.close();
    }

    private void addBuyGas(String userId, Date start, Date end, BigDecimal hand) {
        while (this.segment != null && (this.segment.userId.compareTo(userId) < 0 || this.segment.userId.equals(userId) && this.segment.end.compareTo(start) == -1)) {
            this.segment = this.getSegment();
        }
        while (this.segment != null && this.segment.userId.compareTo(userId) == 0 && this.segment.start.compareTo(end) == -1) {
            this.addBuyAndHand(userId, start, end, hand);
            this.segment = this.getSegment();
        }
    }

    public void addBuyAndHand(String userId, Date start, Date end, BigDecimal hand) {
        Date left = start;
        if (this.segment.start.compareTo(start) == 1) {
            left = this.segment.start;
        }
        Date right = end;
        if (this.segment.end.compareTo(end) == -1) {
            right = this.segment.end;
        }
        BigDecimal days = new BigDecimal(this.getSubDays(left, right));
        BigDecimal buyDays = new BigDecimal(this.getSubDays(this.segment.start, this.segment.end));
        BigDecimal handDays = new BigDecimal(this.getSubDays(start, end));
        BigDecimal buy = this.segment.gas.divide(buyDays, 2).multiply(days);
        this.gasSum = this.gasSum.add(buy);
        BigDecimal read = hand.divide(handDays, 2).multiply(days);
        this.handSum = this.handSum.add(read);
    }

    public BigDecimal getBuyGas(Date start, Date end, Date segStart, Date segEnd, BigDecimal gas) {
        Date left = start;
        if (segStart.compareTo(start) == 1) {
            left = segStart;
        }
        Date right = end;
        if (segEnd.compareTo(end) == -1) {
            right = segEnd;
        }
        BigDecimal days = new BigDecimal(this.getSubDays(left, right));
        BigDecimal buyDays = new BigDecimal(this.getSubDays(segStart, segEnd));
        BigDecimal buy = gas.divide(buyDays, 2).multiply(days);
        return buy;
    }

    public int getSubDays(Date start, Date end) {
        long nd = 86400000L;
        long diff = end.getTime() - start.getTime();
        int day = (int)(diff / nd);
        return day;
    }

    public ScrollableResults createBuyResultset() {
        this.buySession = this.sessionFactory.openSession();
        String buySql = "select * from (\n\tselect f_user_id, to_date(to_char(f_delivery_date,'yyyy-mm-dd'),'yyyy-mm-dd') f_delivery_date, sum(f_pregas) f_pregas\n\t from t_sellinggas\n\tgroup BY f_user_id, f_delivery_date\n) t_gas\nORDER BY f_user_id, f_delivery_date";
        SQLQuery buyQuery = this.buySession.createSQLQuery(buySql);
        this.buyResultset = buyQuery.scroll();
        return this.buyResultset;
    }

    public void closeBuySession() {
        this.buySession.close();
    }

    public BuySegment getSegment() {
        while (this.buyResultset.next()) {
            Object[] obj = this.buyResultset.get();
            String cUserId = obj[0].toString();
            Date doDate = (Date)obj[1];
            BigDecimal buyGas = (BigDecimal)obj[2];
            if (this.segment.userId.equals(cUserId)) {
                this.segment.start = this.segment.end;
                this.segment.end = doDate;
                this.segment.gas = this.segment.preGas;
                this.segment.preGas = buyGas;
                return this.segment;
            }
            this.segment.userId = cUserId;
            this.segment.end = doDate;
            this.segment.preGas = buyGas;
        }
        this.segment = null;
        return null;
    }

    public class BuySegment {
        public String userId = "";
        public Date start;
        public Date end;
        public BigDecimal preGas;
        public BigDecimal gas;

        public String toString() {
            JSONObject result = new JSONObject();
            result.put("userId", (Object)this.userId);
            result.put("start", (Object)this.start);
            result.put("end", (Object)this.end);
            result.put("preGas", (Object)this.preGas);
            result.put("gas", (Object)this.gas);
            return result.toString();
        }

        public void set(String userId, Date start, Date end, BigDecimal gas) {
            this.userId = userId;
            this.start = start;
            this.end = end;
            this.gas = gas;
        }
    }
}

