SELECT
	f_user_type f_gasproperties_type,
	f_gasproperties,
	SUM (newadduser) newadduser,
	SUM (ACCOUNT) ACCOUNT,
	SUM (startuser) startuser,
	SUM (stopuser) stopuser,
	SUM (nowuser) nowuser
FROM
	(
		--查询时间段内新增用户数
		SELECT
			f.f_user_type,
			f.f_gasproperties,
			0 beforeuser,
			COUNT (U .f_userinfo_id) newadduser,
			0 ACCOUNT,
			0 startuser,
			0 stopuser,
			0 nowuser
		FROM
			t_userfiles f
		LEFT JOIN t_userinfo U ON U .f_userinfo_id = f.f_userinfo_id
		WHERE
			U .f_user_state = '正常'
		AND f_sendcard_date >= TO_DATE (
			'{startDate}',
			'yyyy-mm-dd hh24:mi:ss'
		)
		AND f_sendcard_date <= TO_DATE (
			'{endDate}',
			'yyyy-mm-dd hh24:mi:ss'
		)
		AND f.f_user_type IS NOT NULL
		AND f.f_gasproperties IS NOT NULL
		AND { f_filiale != $$ : $ f.f_filiale = '{f_filiale}' $,
		f_filiale == $$ : $ 1 = 1 $,
		$$ }
	AND { f_outlets != $$ : $f.f_outlets = '{f_outlets}' $,
	f_outlets == $$ : $ 1 = 1 $,
	$$ }
AND { op_id != $$ : $ f.op_id = '{op_id}' $,
 op_id == $$ : $ 1 = 1 $,
 $$ }
AND { op_spot != $$ : $f.op_spot = '{op_spot}' $,
 op_spot == $$ : $ 1 = 1 $,
 $$ }
GROUP BY
	f.f_user_type,
	f.f_gasproperties
UNION ALL
	--查询时间段内销户用户数
	SELECT
		f.f_user_type,
		f.f_gasproperties,
		0 beforeuser,
		0 newadduser,
		COUNT (T . ID) ACCOUNT,
		0 startuser,
		0 stopuser,
		0 nowuser
	FROM
		t_cancellation T
	LEFT JOIN t_userfiles f ON f.f_userinfo_id = T .f_userinfo_id
	WHERE
		T .f_state = '销户'
	AND T .f_operate_date >= TO_DATE (
		'{startDate}',
		'yyyy-mm-dd hh24:mi:ss'
	)
	AND T .f_operate_date <= TO_DATE (
		'{endDate}',
		'yyyy-mm-dd hh24:mi:ss'
	)
	AND f.f_user_type IS NOT NULL
	AND f.f_gasproperties IS NOT NULL
	AND { f_filiale != $$ : $ f.f_filiale = '{f_filiale}' $,
	f_filiale == $$ : $ 1 = 1 $,
	$$ }
AND { f_outlets != $$ : $f.f_outlets = '{f_outlets}' $,
 f_outlets == $$ : $ 1 = 1 $,
 $$ }
AND { op_id != $$ : $ f.op_id = '{op_id}' $,
 op_id == $$ : $ 1 = 1 $,
 $$ }
AND { op_spot != $$ : $f.op_spot = '{op_spot}' $,
 op_spot == $$ : $ 1 = 1 $,
 $$ }
GROUP BY
	f.f_user_type,
	f.f_gasproperties
UNION ALL
	--查询时间段内启用的用户数
	SELECT
		f.f_user_type,
		f.f_gasproperties,
		0 beforeuser,
		0 newadduser,
		0 ACCOUNT,
		COUNT (T . ID) startuser,
		0 stopuser,
		0 nowuser
	FROM
		t_enable T
	LEFT JOIN t_userfiles f ON T .f_userinfo_id = f.f_userinfo_id
	WHERE
		T .f_operate_date >= TO_DATE (
			'{startDate}',
			'yyyy-mm-dd hh24:mi:ss'
		)
	AND T .f_operate_date <= TO_DATE (
		'{endDate}',
		'yyyy-mm-dd hh24:mi:ss'
	)
	AND f.f_user_type IS NOT NULL
	AND f.f_gasproperties IS NOT NULL
	AND { f_filiale != $$ : $ f.f_filiale = '{f_filiale}' $,
	f_filiale == $$ : $ 1 = 1 $,
	$$ }
AND { f_outlets != $$ : $f.f_outlets = '{f_outlets}' $,
 f_outlets == $$ : $ 1 = 1 $,
 $$ }
AND { op_id != $$ : $ f.op_id = '{op_id}' $,
 op_id == $$ : $ 1 = 1 $,
 $$ }
AND { op_spot != $$ : $f.op_spot = '{op_spot}' $,
 op_spot == $$ : $ 1 = 1 $,
 $$ }
GROUP BY
	f.f_user_type,
	f.f_gasproperties
UNION ALL
	--查询时间段内停用的用户数
	SELECT
		f.f_user_type,
		f.f_gasproperties,
		0 beforeuser,
		0 newadduser,
		0 ACCOUNT,
		0 startuser,
		COUNT (T . ID) stopuser,
		0 nowuser
	FROM
		t_disable T
	LEFT JOIN t_userfiles f ON T .f_userinfo_id = f.f_userinfo_id
	WHERE
		T .f_operate_date >= TO_DATE (
			'{startDate}',
			'yyyy-mm-dd hh24:mi:ss'
		)
	AND T .f_operate_date <= TO_DATE (
		'{endDate}',
		'yyyy-mm-dd hh24:mi:ss'
	)
	AND f.f_user_type IS NOT NULL
	AND f.f_gasproperties IS NOT NULL
	AND { f_filiale != $$ : $ f.f_filiale = '{f_filiale}' $,
	f_filiale == $$ : $ 1 = 1 $,
	$$ }
AND { f_outlets != $$ : $f.f_outlets = '{f_outlets}' $,
 f_outlets == $$ : $ 1 = 1 $,
 $$ }
AND { op_id != $$ : $ f.op_id = '{op_id}' $,
 op_id == $$ : $ 1 = 1 $,
 $$ }
AND { op_spot != $$ : $f.op_spot = '{op_spot}' $,
 op_spot == $$ : $ 1 = 1 $,
 $$ }
GROUP BY
	f.f_user_type,
	f.f_gasproperties
	) s
GROUP BY
	f_user_type,
	f_gasproperties