--付款方式分项汇总
SELECT
	f_payment,
	COUNT (ID) c,
	NVL (SUM(f_pregas), 0) f_pregas,
	NVL (SUM(f_preamount), 0) f_preamount,
	NVL (SUM(f_collection), 0) f_collection
FROM
	t_sellinggas
WHERE
	f_state = '有效'
AND f_operate_date >= TO_DATE (
	'{startDate} 00:00:00',
	'yyyy-mm-dd hh24:mi:ss'
)
AND f_operate_date <= TO_DATE (
	'{endDate} 23:59:59',
	'yyyy-mm-dd hh24:mi:ss'
)
AND { f_filiale != $$ : $ f_filiale = '{f_filiale}' $,
 f_filiale == $$ : $ 1 = 1 $,
 $$ }
AND { f_outlets != $$ : $ f_outlets = '{f_outlets}' $,
 f_outlets == $$ : $ 1 = 1 $,
 $$ }
AND { op_id != $$ : $ op_id = '{op_id}' $,
 op_id == $$ : $ 1 = 1 $,
 $$ }
AND { op_spot != $$ : $ op_spot = '{op_spot}' $,
 op_spot == $$ : $ 1 = 1 $,
 $$ }
GROUP BY
	f_payment