SELECT f_parameter_name,{groupname} f_parameter_date,COUNT(*) s,SUM(f_type1) f_type1
from (
    SELECT
        p.f_parameter_name,
        case when p.f_parameter_state='-处理-' then 1 else 0 end f_type1,
        convert(varchar(10), p.f_parameter_date, 121) f_parameter_date,
        convert(varchar(4),p.f_parameter_date,23)+'年' year,
		convert(varchar(7),p.f_parameter_date,23) month,
		cast(Datename(week,p.f_parameter_date) as varchar)+'周'  week,
		convert(varchar(50),p.f_parameter_date,23) day
    FROM t_userparameter AS p
    LEFT JOIN t_userfiles AS f ON p.f_meternumber = f.f_meternumber
    LEFT JOIN t_userinfo AS u ON f.f_userinfo_id = u.f_userinfo_id
    where p.f_parameter_state!='处理完成' and p.f_parameter_date>='{startDate}'
     and p.f_parameter_date<='{endDate}' and {condition}
    GROUP BY p.f_parameter_date,p.f_parameter_name,p.f_parameter_state
) t
GROUP BY {groupname},f_parameter_name
ORDER BY {groupname}