SELECT
	*
FROM
	(
		SELECT
		m1.f_card_id,
		    m3.f_userinfo_id,
			m3.f_userinfo_code,
			--客户编号
			m3.f_user_name,
		       m2.f_residential_area,
			--客户名称
			m2.f_address,
			--客户地址
			m1.f_meternumber,
			--表号
			m1.f_meter_base,
			--最后表读数
			nvl(
			m1.f_gas_date,
				m3.F_CREATEFILE_DATE
			) f_startuse_date,
			--启用日期
			-- 防止启用日期没值页面显示null，没有启用日期取通气日期，没用通气日期取录入日期
			nvl(
			to_char(m5.initinsertdate,'yyyy-MM-dd hh24:mi:ss'),
				'开户未上报'
			) initinsertdate,
			--初次上报日期
			nvl(
	to_char(m5.lastinsertdate,'yyyy-MM-dd hh24:mi:ss'),
				'开户未上报'
			) lastinsertdate,
			--最后上报日期
			CASE
		WHEN lastinsertdate IS NULL THEN
	round(to_date(to_char(sysdate,'yyyy-MM-dd'),'yyyy-MM-dd')-		nvl(
	cast(m1.f_gas_date as date ),
		cast(m3.F_CREATEFILE_DATE as date )
				),0)
		ELSE
round(to_date(to_char(sysdate,'yyyy-MM-dd'),'yyyy-MM-dd')-to_date(to_char(m5.lastinsertdate,'yyyy-MM-dd'),'yyyy-MM-dd'),0)
		END SLday,
		--失联天数
		m1.f_orgid,
		m2.f_slice_area,
		--组织ID
		m1.f_orgname,
		--组织名称
		m1.f_user_type,
		--客户类型
		m1.f_gasproperties,
		m6.f_signal,
		m1.f_table_state,
		m6.f_batterylevel,
		case when m6.f_valvestate = '0' then '开'
		else '关' end f_valvestate,
		--用气性质
		m4.f_meter_brand --气表品牌
	FROM
		t_userfiles m1
			LEFT JOIN t_userinfo m3 ON m1.f_userinfo_id = m3.f_userinfo_id
	  LEFT JOIN t_user_address m2 ON m3.f_useraddress_id = m2.id
	LEFT JOIN t_gasbrand m4 ON m1.f_gasbrand_id = m4.id
	LEFT JOIN (
		SELECT
			f_user_id,
			MIN (f_insert_date) initinsertdate,
			--初次接收时间
			MAX (f_insert_date) lastinsertdate --最后接收时间
		FROM
			t_meteread
		GROUP BY
			f_user_id
	) m5 ON m1.f_user_id = m5.f_user_id

	left  join t_meteread m6
	on m6.f_insert_date =m5.lastinsertdate and m6.f_user_id = m5.f_user_id
	WHERE
		m1.f_meter_classify like '%物联网%'
	) k
WHERE
	{condition}
ORDER BY
	f_userinfo_code
