SELECT DISTINCT
	*
FROM
	(
		SELECT
			s.f_meternumber,
			--表钢号
			s.f_user_name,
			--用户名称
			s.f_address,
			--地址
			s.f_user_type,
			--用户类型
			s.f_userinfo_code,
			s.f_gasproperties,
			--用气性质
			h1.f_jval f_balance,
			--期初余额(元)
			h1.f_tablebase f_last_tablebase,
			--上期读数
			h2.f_tablebase,
			--本期读数
			--		s.f_collection,		--充值金额
			s.f_orgname,
			h2.f_tablebase - h1.f_tablebase f_oughtamount,
			--用气气量(m²)
			(
				h2.f_tablebase - h1.f_tablebase
			) * h2.f_price f_oughtfee,
			--用气金额(元)
			-- 		Convert(decimal(18,2),s.f_oughtfee/(case when s.f_oughtamount = 0 then 1 else s.f_oughtamount end)) f_avg_price,--平均单价(元/m²)
			h2.f_jval f_curbalance,
			--期末结余(元)
			h1.f_hand_date f_last_hand_date,
			h2.f_hand_date f_end_hand_date --convert(varchar(11),h1.f_hand_date,23)+'至'+convert(varchar(11),h2.f_hand_date,23) f_hand_date,--用气区间
		FROM
			(
				SELECT
					*
				FROM
					(
						SELECT
							H .f_meternumber,
							H .f_user_id,
							U .f_user_name,
							A .f_address,
							U .f_userinfo_code,
							uf.f_user_type,
							uf.f_gasproperties,
							uf.f_orgname,
							uf.f_depname,
							D .f_devices_type,
							MIN (H . ID) minid,
							MAX (H . ID) maxid,
							H .f_manufacturers f_meter_brand
						FROM
							T_METEREAD H
						LEFT JOIN t_userfiles uf ON H .f_user_id = uf.f_user_id
						LEFT JOIN t_userinfo U ON uf.f_userinfo_id = U .f_userinfo_id
						LEFT JOIN t_user_address A ON A .f_userinfo_id = U .f_userinfo_id
						LEFT JOIN t_devices D ON D .f_user_id = uf.f_user_id -- 		left join t_sellinggas s on s.f_meternumber=uf.f_meternumber and s.f_user_id=uf.f_user_id
						WHERE
							H .f_hand_date >= TO_DATE (
								'{startDate}',
								'yyyy-MM-dd hh24:mi:ss'
							)
						AND H .f_hand_date <= TO_DATE (
							'{endDate}',
							'yyyy-MM-dd hh24:mi:ss'
						)
						AND H .f_upload_type LIKE '%定时上报%'
						GROUP BY
							H .f_meternumber,
							H .f_manufacturers,
							H .f_user_id,
							U .f_user_name,
							A .f_address,
							uf.f_user_type,
							uf.f_gasproperties,
							U .f_userinfo_code,
							uf.f_orgname,
							uf.f_depname,
							D .f_devices_type
					)
				WHERE
					{condition}
			) s
		LEFT JOIN T_METEREAD h1 ON s.minid = h1. ID
		LEFT JOIN T_METEREAD h2 ON s.maxid = h2. ID
	) s
ORDER BY
	f_meternumber DESC