SELECT
	{ items }
FROM
	(
	SELECT
							F_METERNUMBER,
							f_error_type,
							f_error_level,
							f_error_msg,
							f_error_reason,
							f_insert_date,
							TO_NUMBER (F_USER_ID) F_USER_ID
						FROM
							T_EXCEPTION
						UNION ALL
							--电压状态
							SELECT
								F_METERNUMBER,
								'上报异常' f_error_type,
								'故障型' f_error_level,
								'电压异常' f_error_msg,
								'' f_error_reason,
								f_insert_date f_insert_date,
								F_USER_ID
							FROM
								T_METEREAD
							WHERE
								f_LowLithiumBattery = '1'
							UNION ALL
								--磁干扰异常
								SELECT
									F_METERNUMBER,
									'上报异常' f_error_type,
									'故障型' f_error_level,
									'磁干扰异常' f_error_msg,
									'' f_error_reason,
									f_insert_date f_insert_date,
									F_USER_ID
								FROM
									T_METEREAD
								WHERE
									f_magneticInterference = '1'
								UNION ALL
									--采样异常
									SELECT
										F_METERNUMBER,
										'上报异常' f_error_type,
										'故障型' f_error_level,
										'采样异常' f_error_msg,
										'' f_error_reason,
										f_insert_date f_insert_date,
										F_USER_ID
									FROM
										T_METEREAD
									WHERE
										f_timesException = '1'
									UNION ALL
										--报警关阀
										SELECT
											F_METERNUMBER,
											'上报异常' f_error_type,
											'故障型' f_error_level,
											'报警关阀' f_error_msg,
											'' f_error_reason,
											f_insert_date f_insert_date,
											F_USER_ID
										FROM
											T_METEREAD
										WHERE
											f_alarmShutValve = '1'
										UNION ALL
											--过流保护
											SELECT
												F_METERNUMBER,
												'上报异常' f_error_type,
												'故障型' f_error_level,
												'过流保护' f_error_msg,
												'' f_error_reason,
												f_insert_date f_insert_date,
												F_USER_ID
											FROM
												T_METEREAD
											WHERE
												f_overCurrentProtection = '1'
    UNION ALL
                            --采样异常
    SELECT
    F_METERNUMBER,
    '采样异常' f_error_type,
    '故障型' f_error_level,
    '表具处于采样异常状态' f_error_msg,
    '' f_error_reason,
    f_insert_date f_insert_date,
    F_USER_ID
    FROM
    T_METEREAD
    WHERE
    f_timesException = '0'
                            --死表
    UNION ALL
    SELECT
    F_METERNUMBER,
    '死表' f_error_type,
    '故障型' f_error_level,
    '表具处于死表状态' f_error_msg,
    '' f_error_reason,
    f_insert_date f_insert_date,
    F_USER_ID
    FROM
    T_METEREAD
    WHERE
    f_die_meter is null
                            --关阀走气
    UNION ALL
    SELECT
    F_METERNUMBER,
    '关阀走气' f_error_type,
    '故障型' f_error_level,
    '表具出现关阀走气异常' f_error_msg,
    '' f_error_reason,
    f_insert_date f_insert_date,
    F_USER_ID
    FROM
    T_METEREAD
    WHERE
    f_leakageFlag is null
                            --拆表报警
    UNION ALL
    SELECT
    F_METERNUMBER,
    '拆表报警' f_error_type,
    '故障型' f_error_level,
    '表具出现拆表报警异常,拆表日期' f_error_msg,
    '' f_error_reason,
    f_insert_date f_insert_date,
    F_USER_ID
    FROM
    T_EXCEPTION
                            --强制报废
    UNION ALL
    SELECT
    F_METERNUMBER,
    '强制报废' f_error_type,
    '故障型' f_error_level,
    '表具出现拆表报警异常,拆表日期' f_error_msg,
    '' f_error_reason,
    f_insert_date f_insert_date,
    F_USER_ID
    FROM
    T_EXCEPTION
                            --警示型
    UNION ALL
    SELECT
    F_METERNUMBER,
    '拆表报警' f_error_type,
    '警示型' f_error_level,
    '表具处于强制安检预警状态' f_error_msg,
    '' f_error_reason,
    f_insert_date f_insert_date,
    F_USER_ID
    FROM
    T_EXCEPTION
                            --警示型
    UNION ALL
    SELECT
    F_METERNUMBER,
    '欠费关阀' f_error_type,
    '警示型' f_error_level,
    '表具处于欠费关阀状态' f_error_msg,
    '' f_error_reason,
    f_insert_date f_insert_date,
    F_USER_ID
    FROM
    T_EXCEPTION
                            --警示型
    UNION ALL
    SELECT
    F_METERNUMBER,
    '强制安检' f_error_type,
    '警示型' f_error_level,
    '表具处于强制安检状态' f_error_msg,
    '' f_error_reason,
    f_insert_date f_insert_date,
    F_USER_ID
    FROM
    T_EXCEPTION
                            --警示型
    UNION ALL
    SELECT
    F_METERNUMBER,
    '周期关阀' f_error_type,
    '警示型' f_error_level,
    '表具处于强制安检状态' f_error_msg,
    '' f_error_reason,
    f_insert_date f_insert_date,
    F_USER_ID
    FROM
    T_EXCEPTION
	)
		WHERE
			{ condition }
