SELECT
	*
FROM
	(
		SELECT
			f_card_id,
			f_userinfo_id,
			f_user_name,
			--用户姓名
			f_userinfo_code,
			--用户编号
			f_orgname,
			--组织机构
			f_address,
			--用户地址
			f_meternumber,
			--表钢号
			f_user_type,
			--用户类型
			f_gasproperties,
			--用气性质
			f_meter_brand,
			--气表品牌
			f_error_type,
			f_error_level,
			f_error_msg,
			f_error_reason,
			f_insert_date,
			f_orgid
		FROM
			(
				SELECT
					f.f_card_id,
					U .f_userinfo_id,
					U .f_user_name,
					u.f_distinct,
					u.f_opera_area,
					a.f_residential_area,
					a.f_street,
					U .f_userinfo_code,
					f.f_orgname,
					f.f_meternumber,
					E .f_error_type,
					E .f_error_level,
					E .f_error_msg,
					E .f_error_reason,
					E .f_insert_date,
					f.f_user_type,
					f.f_gasproperties,
					A .f_address,
					U .f_orgid,
					gb.f_meter_brand
				FROM
					(
						SELECT
							F_METERNUMBER,
							f_error_type,
							f_error_level,
							f_error_msg,
							f_error_reason,
							f_insert_date,
							TO_NUMBER (F_USER_ID) F_USER_ID
						FROM
							T_EXCEPTION
						UNION ALL
							--电压状态
							SELECT
								F_METERNUMBER,
								'上报异常' f_error_type,
								'故障型' f_error_level,
								'电压异常' f_error_msg,
								'' f_error_reason,
								f_insert_date f_insert_date,
								F_USER_ID
							FROM
								T_METEREAD
							WHERE
								f_LowLithiumBattery = '1'
							UNION ALL
								--磁干扰异常
								SELECT
									F_METERNUMBER,
									'上报异常' f_error_type,
									'故障型' f_error_level,
									'磁干扰异常' f_error_msg,
									'' f_error_reason,
									f_insert_date f_insert_date,
									F_USER_ID
								FROM
									T_METEREAD
								WHERE
									f_magneticInterference = '1'
								UNION ALL
									--采样异常
									SELECT
										F_METERNUMBER,
										'上报异常' f_error_type,
										'故障型' f_error_level,
										'采样异常' f_error_msg,
										'' f_error_reason,
										f_insert_date f_insert_date,
										F_USER_ID
									FROM
										T_METEREAD
									WHERE
										f_timesException = '1'
									UNION ALL
										--报警关阀
										SELECT
											F_METERNUMBER,
											'上报异常' f_error_type,
											'故障型' f_error_level,
											'报警关阀' f_error_msg,
											'' f_error_reason,
											f_insert_date f_insert_date,
											F_USER_ID
										FROM
											T_METEREAD
										WHERE
											f_alarmShutValve = '1'
					) E
				LEFT JOIN t_userfiles f ON f.f_user_id = E .f_user_id
				LEFT JOIN t_userinfo U ON U .f_userinfo_id = f.f_userinfo_id
				LEFT JOIN t_user_address A ON f.f_useraddress_id = A . ID
				LEFT JOIN t_gasbrand gb ON f.f_gasbrand_id = gb. ID
				WHERE
					U .f_user_state = '正常'
				AND f.f_table_state = '正常'
			) T
		WHERE
			{ condition }
	) T
ORDER BY
    f_insert_date desc
