SELECT *
FROM (
         SELECT u.f_user_id,
                f_balance_amount,
                f_balance_gas,
                address.f_address,
                address.f_slice_area,
                info.f_userinfo_code,
                info.f_user_phone,
                info.f_user_name,
                info.f_distinct,
                info.f_gas_area,
                info.f_createfile_date,
                info.f_point_name,
                gb.f_meter_brand,
                gm.f_meter_style,
                sp.f_price_type,
                sp.f_price_name,
                listagg(de.f_devices_type, '+')  within group(order by de.f_devices_type) f_devices_type,
                f_fire_date,
                f_inputtor,
                f_jb_type_code,
                f_meternumber,
                u.f_meter_state,
                u.f_user_type,
                u.f_gasproperties,
                f_table_state,
                f_card_id,
                f_whether_hairpin,
                f_barcode,
                f_meter_classify,
                archives_state
         FROM
             t_userfiles U
             LEFT JOIN t_user_address address ON U .f_useraddress_id = address. ID
             LEFT JOIN t_devices de ON de.f_user_id = U. f_user_id
             LEFT JOIN t_userinfo info ON U .f_userinfo_id = info.f_userinfo_id
             LEFT JOIN t_gasbrand gb ON U .f_gasbrand_id = gb. ID
             LEFT JOIN t_gasmodel gm ON U .f_gasmodel_id = gm. ID
             LEFT JOIN t_stairprice sp ON U .f_price_id = sp.f_price_id
             AND sp.f_state = '有效'
             AND SYSDATE >= f_perform_date
             AND SYSDATE <= f_end_date
         group by    u.f_user_id,
             f_balance_amount,
             f_balance_gas,
             address.f_address,
             address.f_slice_area,
             info.f_userinfo_code,
             info.f_user_phone,
             info.f_user_name,
             info.f_distinct,
             info.f_gas_area,
             u.f_meter_state,
             info.f_createfile_date,
             info.f_point_name,
             gb.f_meter_brand,
             gm.f_meter_style,
             sp.f_price_type,
             sp.f_price_name,
             f_fire_date,
             f_inputtor,
             f_jb_type_code,
             f_meternumber,
             u.f_user_type,
             u.f_gasproperties,
             f_table_state,
             f_card_id,
             f_whether_hairpin,
             f_barcode,
             f_meter_classify,
             archives_state
     ) T
WHERE
	{condition}
ORDER BY
	f_user_id DESC
