-- NonCivilianCount_VIEW 视图
-- CREATE OR REPLACE VIEW NonCivilianCount_VIEW as
-- select
--     f_use_company f_user_name,
--     uf.f_gasproperties,
--     ad.f_distinct,
--     ad.f_street,
--     f_gas_area,
--     f_point_name,
--     f_inputtor,
--     uf.f_user_type,
--     uf.f_meter_state,
--     uf.f_user_id,
--     f_card_id,
--     f_devices_type,
--     f_ratedflow,
--     f_equipmentload,
--     f_jb_type,
--     f_meternumber,
--     f_createfile_date,
--     uf.f_isic,
--     nvl(cast ((case when f_devices_type = '锅炉' then
--                         case when to_char(trim (translate (f_equipmentload, '0123456789.', ' '))) is null then f_equipmentload
--                              else to_char(replace(regexp_substr(f_equipmentload, '(([0-9]+)([.]([0-9]+))?|([.]([0-9]+))?)吨'), '吨', ''))
--                             end
--                     else '0' end) as decimal (8, 2)), 0) glnum,
--     nvl(cast ((case when f_devices_type = '生产线' then
--                         case when to_char(trim (translate (f_equipmentload, '0123456789.', ' '))) is null then f_equipmentload
--                              else to_char(replace(regexp_substr(f_equipmentload, '(([0-9]+)([.]([0-9]+))?|([.]([0-9]+))?)吨'), '吨', ''))
--                             end
--                     else '0' end) as decimal (8, 2)), 0) scxnum,
--     nvl(cast ((case when f_devices_type = '餐饮' then
--                         case when to_char(trim (translate (f_equipmentload, '0123456789', ' '))) is null then f_equipmentload
--                              else to_char(replace(regexp_substr(f_equipmentload, '[0-9]+眼'), '眼', ''))
--                             end
--                     else '0' end) as decimal (8, 2)), 0) cynum,
--     nvl(cast ((case when ds.f_devices_type = '壁挂锅炉' or ds.f_devices_type = '热水器' then
--                         case when to_char(trim (translate (f_equipmentload, '0123456789', ' '))) is null then f_equipmentload
--                              else to_char(replace(regexp_substr(f_equipmentload, '[0-9]+台'), '台', ''))
--                             end
--                     else '0' end) as decimal (8, 2)), 0) bfrsnum
-- from t_userfiles uf
--          left join t_userinfo u on uf.f_userinfo_id = u.f_userinfo_id
--          left join t_user_address ad on uf.f_userinfo_id = ad.f_userinfo_id
--          left join t_devices ds on uf.f_user_id = ds.f_user_id
--          left join t_gasbrand gb on gb.id=uf.f_gasbrand_id
-- where uf.f_table_state != '有误'
--         and uf.f_user_type = '非民用'
select
    nvl(ms.f_gas_area,'') f_gas_area,
    nvl(ms.f_point_name,'') f_point_name,
    nvl(ms.f_gasproperties,'') f_gasproperties,
    nvl(ms.f_distinct,'') f_distinct,
    nvl(ms.f_street,'') f_street,
    f_card_id,
    tablenum,
    pmbnum,
    wlnum,
    lcnum,
    glnum,
    scxnum,
    cynum,
    bfrsnum
from (
select
    f_gas_area,
    f_point_name,
    f_gasproperties,
    f_distinct,
    f_street,
    {condValue == $f_gas_area asc$ || condValue == $f_gas_area desc$:$$,$f_card_id,$}
    count (distinct f_user_id) tablenum,
    count (distinct case when f_jb_type = '皮膜表' then f_user_id end) pmbnum,
    count (distinct case when f_jb_type = '涡轮流量计' then f_user_id end) wlnum,
    count (distinct case when f_jb_type = '罗茨流量计' then f_user_id end) lcnum,
    nvl(sum (glnum), 0) glnum,
    nvl(sum (scxnum), 0) scxnum,
    nvl(sum (cynum), 0) cynum,
    nvl(sum (bfrsnum), 0) bfrsnum
from  NonCivilianCount_VIEW ts
    where {condition}
    group by f_gas_area,f_gasproperties,f_distinct,f_street,f_point_name{condValue == $f_gas_area asc$ || condValue == $f_gas_area desc$:$$,$,f_card_id$}
) ms
{condValue == $f_gas_area asc$ || condValue == $f_gas_area desc$:$
left join(
    select
        f_gas_area,
        f_point_name,
        f_gasproperties,
        f_distinct,
        f_street,
        listagg ( f_card_id,',') within group ( order by f_card_id) f_card_id
    from (
        select f_gas_area,
            f_point_name,
            f_gasproperties,
            f_distinct,
            f_street,
            f_card_id
        from NonCivilianCount_VIEW
        where {condition}
        group by f_gas_area, f_gasproperties, f_distinct, f_street, f_card_id, f_point_name
    ) ss
    group by f_gas_area, f_gasproperties, f_distinct, f_street, f_point_name
    order by {condValue}
) ug on ms.f_gas_area= ug.f_gas_area
    and ms.f_gasproperties = ug.f_gasproperties
    and ms.f_distinct = ug.f_distinct
    and ms.f_street = ug.f_street
    and ms.f_point_name = ug.f_point_name
order by {condValue}
$,$
order by f_gas_area,{condValue}
$}
