SELECT
    *
FROM
    (
        SELECT
            s.f_delaypay,
            s.f_collection,
            s.F_USER_TYPE,
            s.F_OPENPL_OUT_TRADE_NO,
            s.F_PAY_PASS,
            s.F_PREAMOUNT,
            s.F_OPERATOR,
            s.F_SERIAL_ID_OLD,
            s.OP_ID,
            s.OP_SPOT,
            s.F_OUTLETS,
            s.F_FILIALE,
            s.BILL_NUM,
            s.IS_BILL,
            s.f_write_card,
            s.F_OPERATE_DATE,
            s.F_PREGAS,
            s.F_STATE,
            s.F_METER_BRAND,
            s.F_METER_TYPE,
            s.F_BILL_STYLE,
            s.F_PAYMENT,
            s.F_GASPROPERTIES,
            s.F_TYPE,
            s.F_ADDRESS,
            info.F_USER_NAME,
            s.F_CARD_ID,
            s.F_SERIAL_ID,
            s.ID,
            uf.F_TABLE_STATE,
            listagg(de.f_devices_type, '+')  within group(order by de.f_devices_type) f_devices_type,
            info.f_createfile_date,
            info.f_userinfo_code,
            info.f_idnumber,
            info.f_user_phone,
            ua.f_residential_area,
            sp.f_price_type,
            b.f_instruct_state,
            sp.f_price_name,
            uf.archives_state,
            NVL(jt1.F_GAS, 0)                                              gas1,
            NVL(jt2.F_GAS, 0)                                              gas2,
            NVL(jt3.F_GAS, 0)                                              gas3,
            NVL(jt1.F_MONEY, 0)                                            money1,
            NVL(jt2.F_MONEY, 0)                                            money2,
            NVL(jt3.F_MONEY, 0)                                            money3,
            NVL(jt1.F_PRICE, 0)                                            PRICE1,
            NVL(jt2.F_PRICE, 0)                                            PRICE2,
            NVL(jt3.F_PRICE, 0)                                            PRICE3,
            NVL(guding.F_GAS, 0)                                           gdgas,
            NVL(guding.F_PRICE, 0)                                         gdPRICE,
            NVL(guding.F_MONEY, 0)                                         gdMONEY
        FROM
            t_sellinggas s
                LEFT JOIN t_userinfo info ON s.f_userinfo_id = info.f_userinfo_id
                left join t_userfiles uf on info.f_userinfo_id = uf.f_userinfo_id
                LEFT JOIN t_devices de ON s.f_userinfo_id = de.f_userinfo_id
                LEFT JOIN t_user_address ua ON info.f_userinfo_id = ua.f_userinfo_id
                LEFT JOIN t_stairprice sp ON s.f_stairprice_id = sp. ID
                left join t_instruct b
                on s.id = b.f_data_id
                LEFT JOIN (
                SELECT
                    F_GAS,
                    F_MONEY,
                    F_PRICE,
                    f_charge_id
                FROM
                    t_chargeprice
                WHERE
                        F_PRICE_NAME = '固定气价'
                  and
                    {
                    startDate != $$ : $ f_operate_date >= to_date('{startDate} 00:00:00','yyyy-mm-dd hh24:mi:ss')  $,
                    startDate == $$ : $ 1 = 1 $,
                    $$
                    }
                  and
                    {
                    endDate != $$ : $ f_operate_date <= to_date('{endDate} 23:59:59','yyyy-mm-dd hh24:mi:ss')  $,
                    endDate == $$ : $ 1 = 1 $,
                    $$
                    }
            ) guding ON s. ID = guding.f_charge_id
                LEFT JOIN (
                SELECT
                    F_GAS,
                    F_MONEY,
                    F_PRICE,
                    f_charge_id
                FROM
                    t_chargeprice
                WHERE
                        F_PRICE_NAME = '阶梯1'
                  and
                    {
                    startDate != $$ : $ f_operate_date >= to_date('{startDate} 00:00:00','yyyy-mm-dd hh24:mi:ss')  $,
                    startDate == $$ : $ 1 = 1 $,
                    $$
                    }
                  and
                    {
                    endDate != $$ : $ f_operate_date <= to_date('{endDate} 23:59:59','yyyy-mm-dd hh24:mi:ss')  $,
                    endDate == $$ : $ 1 = 1 $,
                    $$
                    }
            ) jt1 ON s. ID = jt1.f_charge_id
                LEFT JOIN (
                SELECT
                    F_GAS,
                    F_MONEY,
                    F_PRICE,
                    f_charge_id
                FROM
                    t_chargeprice
                WHERE
                        F_PRICE_NAME = '阶梯2'
                  and
                    {
                    startDate != $$ : $ f_operate_date >= to_date('{startDate} 00:00:00','yyyy-mm-dd hh24:mi:ss')  $,
                    startDate == $$ : $ 1 = 1 $,
                    $$
                    }
                  and
                    {
                    endDate != $$ : $ f_operate_date <= to_date('{endDate} 23:59:59','yyyy-mm-dd hh24:mi:ss')  $,
                    endDate == $$ : $ 1 = 1 $,
                    $$
                    }
            ) jt2 ON s. ID = jt2.f_charge_id
                LEFT JOIN (
                SELECT
                    F_GAS,
                    F_MONEY,
                    F_PRICE,
                    f_charge_id
                FROM
                    t_chargeprice
                WHERE
                        F_PRICE_NAME = '阶梯3'
                  and
                    {
                    startDate != $$ : $ f_operate_date >= to_date('{startDate} 00:00:00','yyyy-mm-dd hh24:mi:ss')  $,
                    startDate == $$ : $ 1 = 1 $,
                    $$
                    }
                  and
                    {
                    endDate != $$ : $ f_operate_date <= to_date('{endDate} 23:59:59','yyyy-mm-dd hh24:mi:ss')  $,
                    endDate == $$ : $ 1 = 1 $,
                    $$
                    }
            ) jt3 ON s. ID = jt3.f_charge_id
        group by s.F_USER_TYPE,
                 s.f_delaypay,
                 s.f_collection,
                 s.F_OPENPL_OUT_TRADE_NO,
                 s.F_PAY_PASS,
                 s.F_PREAMOUNT,
                 s.F_OPERATOR,
                 s.F_SERIAL_ID_OLD,
                 s.OP_ID,
                 s.OP_SPOT,
                 s.F_OUTLETS,
                 s.F_FILIALE,
                 s.BILL_NUM,
                 s.IS_BILL,
                 s.F_OPERATE_DATE,
                 s.F_PREGAS,
                 s.F_STATE,
                 s.F_METER_BRAND,
                 s.F_METER_TYPE,
                 s.F_BILL_STYLE,
                 s.F_PAYMENT,
                 s.F_GASPROPERTIES,
                 s.F_TYPE,
                 s.F_ADDRESS,
                 s.f_write_card,
                 b.f_instruct_state,
                 info.F_USER_NAME,
                 s.F_CARD_ID,
                 s.F_SERIAL_ID,
                 s.ID,
                 uf.F_TABLE_STATE,
                 info.f_createfile_date,
                 info.f_userinfo_code,
                 info.f_idnumber,
                 info.f_user_phone,
                 ua.f_residential_area,
                 sp.f_price_type,
                 sp.f_price_name,
                 uf.archives_state,
                 jt1.F_GAS,
                 jt2.F_GAS,
                 jt3.F_GAS,
                 jt1.F_MONEY,
                 jt2.F_MONEY,
                 jt3.F_MONEY,
                 jt1.F_PRICE,
                 jt2.F_PRICE,
                 jt3.F_PRICE,
                 guding.F_GAS,
                 guding.F_PRICE,
                 guding.F_MONEY
    ) T
WHERE
    { condition }
ORDER BY
    f_operate_date DESC
