SELECT
	f_user_type,
	f_gasproperties,
	f_devices_type,
	count (ID) c,
	SUM (f_pregas) f_gas,
	SUM (f_preamount) f_money
FROM
	(
		SELECT
            listagg(de.f_devices_type, '+') within group (order by de.f_devices_type) f_devices_type,
            sell.f_user_type, sell.id, f_pregas, f_preamount, f_gasproperties
		FROM
			(
				SELECT
                    f_user_type,id,f_pregas,f_preamount,f_gasproperties,f_user_id
				FROM
					T_SELLINGGAS
				WHERE
					f_state = '有效'
				AND f_operate_date >= { entity.findDialect () == $SqlServer$ : $ '{endDate} 00:00:00' $,
				$to_date (
					'{startDate} 00:00:00',
					'yyyy-mm-dd hh24:mi:ss'
				) $ }
			AND f_operate_date <= { entity.findDialect () == $SqlServer$ : $ '{endDate} 00:00:00' $,
			$to_date (
				'{endDate} 23:59:59',
				'yyyy-mm-dd hh24:mi:ss'
			) $ }
		AND { f_filiale != $$ : $ f_filiale = '{f_filiale}' $,
		f_filiale == $$ : $ 1 = 1 $,
		$$ }
	AND { f_outlets != $$ : $ f_outlets = '{f_outlets}' $,
	f_outlets == $$ : $ 1 = 1 $,
	$$ }
AND { op_id != $$ : $ op_id = '{op_id}' $,
 op_id == $$ : $ 1 = 1 $,
 $$ }
AND { op_spot != $$ : $ op_spot = '{op_spot}' $,
 op_spot == $$ : $ 1 = 1 $,
 $$ }
			) sell
		LEFT JOIN T_DEVICES de ON sell.f_user_id = de.f_user_id
        group by sell.F_USER_TYPE, sell.ID, F_PREGAS, F_PREAMOUNT, F_GASPROPERTIES
	)
GROUP BY
	f_user_type,
	f_gasproperties,
	f_devices_type
