SELECT
    *
FROM
    (
        SELECT
            s.f_street,
            s.f_building,
            s.f_unit,
            s.f_floor,
            s.f_room,
            s.f_distinct,
            s.f_price_type,
            s.f_price_id,
            s.f_opera_area,
            s.f_meternumber,
            s.f_user_name,
            s.f_card_id,
            s.f_address,
            s.f_user_type,
            s.f_userinfo_code,
            s.f_gasproperties,
            h1.f_jval f_balance,
            h1.f_tablebase f_last_tablebase,
            h2.f_tablebase,
            s.f_orgname,
            h2.f_tablebase - h1.f_tablebase f_oughtamount,
            s.f_meter_brand,
            s.f_inputtor,
            ( h2.f_tablebase - h1.f_tablebase ) * h2.f_price f_oughtfee,
            h2.f_jval f_curbalance,
            CASE
                WHEN ROUND( CAST( h2.f_hand_date AS DATE ) - CAST( h1.f_hand_date AS DATE ) ) = 0 THEN
                    0 ELSE ROUND(
                        ( h2.f_tablebase - h1.f_tablebase ) / ROUND( CAST( h2.f_hand_date AS DATE ) - CAST( h1.f_hand_date AS DATE ) ),
                        2
                )
                END aveg,
            ROUND( CAST( h2.f_hand_date AS DATE ) - CAST( h1.f_hand_date AS DATE ) ) days,
            h1.f_hand_date f_last_hand_date,
            h2.f_hand_date f_end_hand_date
        FROM
            (
                SELECT
                    b.f_street,
                    b.f_building,
                    b.f_unit,
                    b.f_floor,
                    b.f_room,
                    b.f_distinct,
                    b.f_price_type,
                    b.f_price_id,
                    b.f_opera_area,
                    a.f_meternumber,
                    b.f_user_name,
                    b.f_card_id,
                    b.f_address,
                    b.f_user_type,
                    b.f_orgname,
                    b.f_userinfo_code,
                    b.f_gasproperties,
                    b.f_meter_brand,
                    b.f_inputtor,
                    a.minid,
                    a.maxid
                FROM
                    (
                        SELECT
                            MIN( H.ID ) minid,
                            f_meternumber,
                            MAX( H.ID ) maxid
                        FROM
                            T_METEREAD H
                        WHERE
                                H.f_hand_date >= TO_DATE( '{startDate}', 'yyyy-MM-dd hh24:mi:ss' )
                          AND H.f_hand_date <= TO_DATE( '{endDate}', 'yyyy-MM-dd hh24:mi:ss' )
                        GROUP BY
                            H.f_meternumber
                    ) a
                        LEFT JOIN ( SELECT * FROM T_USERMESSAGE WHERE F_ISOPENACCOUNT IS NOT NULL ) b ON a.F_METERNUMBER = b.f_meternumber
            ) s
                LEFT JOIN T_METEREAD h1 ON s.minid = h1.ID
                LEFT JOIN T_METEREAD h2 ON s.maxid = h2.ID
    )
WHERE
    {condition}
  AND f_meternumber IS NOT NULL
ORDER BY
    {orderitem}