//查询时间区间内失联情况
select * from (
SELECT
		{groupname} res,
	COUNT (DISTINCT f_meternumber)
VALUE

FROM
	(
		SELECT
			U .f_meternumber,
			U .f_user_type,
			U .f_gasproperties,
			max_days,
			all_days,
			CASE
		WHEN max_days IS NULL THEN
			'F_未上报'
		WHEN max_days <= 1 THEN
			'正常上报'
		WHEN max_days > 1
		AND max_days < 5 THEN
			'A_5天之内'
		WHEN max_days >= 5
		AND max_days < 7 THEN
			'B_5-7天'
		WHEN max_days >= 7
		AND max_days < 15 THEN
			'C_7-15天'
		WHEN max_days >= 15
		AND max_days < 30 THEN
			'D_15-30天'
		WHEN max_days >= 30
		AND max_days < 60 THEN
			'E_30-60天'
		WHEN max_days >= 60 THEN
			'F_60天以上'
		ELSE
			'未上报'
		END max_days_type,
		--最长失联天数类型
		CASE
	WHEN all_days IS NULL THEN
		'F_未上报'
	WHEN all_days <= 1 THEN
		'正常上报'
	WHEN all_days > 1
	AND all_days < 5 THEN
		'A_5天之内'
	WHEN all_days >= 5
	AND all_days < 7 THEN
		'B_5-7天'
	WHEN all_days >= 7
	AND all_days < 15 THEN
		'C_7-15天'
	WHEN all_days >= 15
	AND all_days < 30 THEN
		'D_15-30天'
	WHEN all_days >= 30
	AND all_days < 60 THEN
		'E_30-60天'
	WHEN all_days >= 60 THEN
		'F_60天以上'
	ELSE
		'未上报'
	END all_days_type,
	--合计失联天数类型
	U .f_orgid,
	U .f_orgname,
	U .f_depid,
	U .f_depname
FROM
	t_userfiles U
LEFT JOIN t_userinfo uf ON U .f_userinfo_id = uf.f_userinfo_id
LEFT JOIN (
	SELECT
		m1.f_user_id,
		m1.f_card_id,
		m3.f_userinfo_id,
		m3.f_userinfo_code,
		--客户编号
		m3.f_user_name,
		--客户名称
		m2.f_address,
		--客户地址
		m1.f_meternumber,
		--表号,
		m6.init_date,
		NVL (
			m1.f_gas_date,
			m3.F_CREATEFILE_DATE
		) f_startuse_date,
		--启用日期
		CASE
	WHEN m5.max_interval_day IS NULL THEN
		ROUND (
			TO_DATE (
				TO_CHAR (SYSDATE, 'yyyy-MM-dd'),
				'yyyy-MM-dd'
			) - TO_DATE (
				SUBSTR ('{startDate}', 0, 10),
				'yyyy-MM-dd'
			),
			0
		)
	WHEN m5.max_interval_day > ROUND (
		TO_DATE (
			TO_CHAR (SYSDATE, 'yyyy-MM-dd'),
			'yyyy-MM-dd'
		) - TO_DATE (
			TO_CHAR (m5.last_date, 'yyyy-MM-dd'),
			'yyyy-MM-dd'
		),
		0
	) THEN
		m5.max_interval_day
	ELSE
		ROUND (
			TO_DATE (
				TO_CHAR (SYSDATE, 'yyyy-MM-dd'),
				'yyyy-MM-dd'
			) - TO_DATE (
				TO_CHAR (m5.last_date, 'yyyy-MM-dd'),
				'yyyy-MM-dd'
			),
			0
		)
	END max_days,
	--最长失联间隔 .上报记录里最大间隔>最后一次上报时间距离结束时间段，取后者，否则取前者
	--实报天数
	CASE
WHEN TO_CHAR (
	init_date,
	'yyyy-MM-dd hh24:mi:ss'
) < '{startDate}' THEN
	ROUND (
		TO_DATE (
			TO_CHAR (SYSDATE, 'yyyy-MM-dd'),
			'yyyy-MM-dd'
		) - TO_DATE (
			SUBSTR ('{startDate}', 0, 10),
			'yyyy-MM-dd'
		),
		0
	) + 1 - NVL (m5.SBdays, 0)
ELSE
	ROUND (
		TO_DATE (
			TO_CHAR (SYSDATE, 'yyyy-MM-dd'),
			'yyyy-MM-dd'
		) - TO_DATE (
			TO_CHAR (m6.init_date, 'yyyy-MM-dd'),
			'yyyy-MM-dd'
		),
		0
	) + 1 - NVL (m5.SBdays, 0)
END all_days,
 --累计失联天数
m1.f_orgid,
 --组织ID
m1.f_orgname,
 --组织名称
m1.f_user_type,
 --客户类型
m1.f_gasproperties,
 --用气性质
m4.f_meter_brand,
 --气表品牌
m1.f_table_state --气表状态
FROM
	t_userfiles m1
LEFT JOIN t_userinfo m3 ON m1.f_userinfo_id = m3.f_userinfo_id
LEFT JOIN t_user_address m2 ON m3.f_useraddress_id = m2. ID
LEFT JOIN t_gasbrand m4 ON m1.f_gasbrand_id = m4. ID
LEFT JOIN (
	SELECT
		f_user_id,
		COUNT (*) SBdays,
		--总共上报天数
		MAX (last_date) last_date,
		--区间内最后报时间
		MAX (max_interval_day) max_interval_day --区间内最大间隔时间
	FROM
		(
			SELECT
				f_user_id,
				MAX (f_insert_date) last_date,
				--区间内最后报时间
				MAX (interval_day) max_interval_day --区间内最大间隔时间
			FROM
				(
					SELECT
						f_user_id,
						f_insert_date,
						CASE
					WHEN f_last_insertdate IS NULL THEN
						1
					ELSE
						ROUND (
							CAST (f_insert_date AS DATE) - CAST (f_last_insertdate AS DATE),
							0
						)
					END interval_day --拿到每条上报时间据上次的时间间隔，第一条上报间隔算1天
					FROM
						t_meteread
					WHERE
						f_insert_date >= TO_DATE (
							'{startDate}',
							'yyyy-MM-dd hh24:mi:ss'
						)
					AND f_insert_date <= TO_DATE (
						'{endDate}',
						'yyyy-MM-dd hh24:mi:ss'
					)
				) ss
			GROUP BY
				f_user_id,
				TO_CHAR (f_insert_date, 'yyyy-MM-dd') --同一天多次上报算一条
		) xx
	GROUP BY
		f_user_id
) m5 ON m1.f_user_id = m5.f_user_id
LEFT JOIN (
	SELECT
		f_user_id,
		MIN (f_insert_date) init_date
	FROM
		t_meteread
	WHERE
		f_insert_date < TO_DATE (
			'{endDate}',
			'yyyy-MM-dd hh24:mi:ss'
		)
	GROUP BY
		f_user_id --只拿区间结束时间前上报过的表和表初次上报时间
) m6 ON m1.f_user_id = m6.f_user_id
WHERE
	m1.f_meter_classify LIKE '%物联网%'
AND NVL (
	F_CREATEFILE_DATE,
	f_input_date
) <= TO_DATE (
	'{endDate}',
	'yyyy-MM-dd hh24:mi:ss'
) --过滤结束时间后的开户表
AND m6.init_date IS NOT NULL
) s ON U .f_user_id = s.f_user_id
AND s.f_meternumber = U .f_meternumber
WHERE
	f_meter_classify LIKE '%物联网%'
AND f_isopenaccount IS NOT NULL
	) s
GROUP BY
	{groupname}
) b
