SELECT
	f_type,
	num,
	TRUNC (num / sumnum, 4) * 100 scale
FROM
	(
		SELECT
			*
		FROM
			(
				SELECT
					COUNT (*) num,
					(
						SELECT
							COUNT (*) NUM
						FROM
							(
								SELECT
									F_METERNUMBER
								FROM
									(
										SELECT
											*
										FROM
											(
												(
													SELECT
														B.*, A .F_GASPROPERTIES,
														A .f_user_type
													FROM
														T_METEREAD B
													LEFT JOIN T_USERFILES A ON A .F_METERNUMBER = B.F_METERNUMBER
												)
											)
										WHERE
											f_user_type != '非民用'
										AND f_insert_date >= TO_DATE (
											'{startDate}',
											'yyyy-MM-dd hh24:mi:ss'
										)
										AND f_insert_date <= TO_DATE (
												'{endDate}',
											'yyyy-MM-dd hh24:mi:ss'
										)
									)
								GROUP BY
									F_METERNUMBER
							)
					) sumnum,
					f_type
				FROM
					(
						SELECT
							F_METERNUMBER,
							CASE
						WHEN diff < 3 THEN
							'A:0-3'
						WHEN diff >= 3
						AND diff < 6 THEN
							'B:3-6'
						WHEN diff >= 6
						AND diff < 9 THEN
							'C:6-9'
						WHEN diff >= 9
						AND diff < 12 THEN
							'D:9-12'
						WHEN diff >= 12
						AND diff < 15 THEN
							'E:12-15'
						WHEN diff >= 15
						AND diff < 18 THEN
							'F:15-18'
						WHEN diff > 18 THEN
							'G:大于18'
						END f_type
						FROM
							(
								SELECT
									F_METERNUMBER,
									MAX (F_TABLEBASE) - MIN (F_TABLEBASE) diff
								FROM
									(
										SELECT
											*
										FROM
											(
												(
													SELECT
														B.*, A .F_GASPROPERTIES,
														A .f_user_type
													FROM
														T_METEREAD B
													LEFT JOIN T_USERFILES A ON A .F_METERNUMBER = B.F_METERNUMBER
												)
											)
										WHERE
											f_user_type != '非民用'
											AND f_insert_date >= TO_DATE (
											'{startDate}',
											'yyyy-MM-dd hh24:mi:ss'
										)
										AND f_insert_date <= TO_DATE (
												'{endDate}',
											'yyyy-MM-dd hh24:mi:ss'
										)
									)
								GROUP BY
									F_METERNUMBER
							)
					)
				GROUP BY
					f_type
			)
	)
ORDER BY
	f_type