SELECT
    *
FROM
    (
        SELECT DISTINCT
            f_card_id,
            f_userinfo_id,
            f_user_name,
            f_street,
            f_residential_area,

        	f_opera_area,
            f_distinct,
            f_userinfo_code,
--组织机构
            f_address,
--用户地址
            a.f_meternumber,
--表钢号
            f_user_type,
--用户类型
            f_gasproperties,
--用气性质
            f_meter_brand,
--气表品牌
            f_error_type,
            f_error_level,
            f_error_msg,
            f_error_reason,
            f_insert_date
        FROM
            (
                SELECT
                    F_METERNUMBER,
                    f_error_type,
                    f_error_level,
                    f_error_msg,
                    f_error_reason,
                    f_insert_date,
                    TO_NUMBER( F_USER_ID ) F_USER_ID
                FROM
                    T_EXCEPTION
                WHERE
                        F_INSERT_DATE >= to_date( {startDate}, 'yyyy-MM-dd hh24:mi:ss' )
                  AND F_INSERT_DATE <= to_date( {endDate}, 'yyyy-MM-dd hh24:mi:ss' ) UNION ALL
                                                                                     select * from (
                SELECT
                    f_meternumber,
                    '上报异常' f_error_type,
                    '故障型' f_error_level,
                    CASE

                        WHEN f_LowLithiumBattery = '1' THEN
                            '电压异常'
                        WHEN f_magneticInterference = '1' THEN
                            '磁干扰异常'
                        WHEN f_timesException = '1' THEN
                            '采样异常'
                        WHEN f_alarmShutValve = '1' THEN
                            '报警关阀'
                        END f_error_msg,
                    NULL f_error_reason,
                    f_insert_date f_insert_date,
                    F_USER_ID
                FROM
                    T_METEREAD
                WHERE
                        F_INSERT_DATE >= to_date( {startDate}, 'yyyy-MM-dd hh24:mi:ss' )
                  AND F_INSERT_DATE <= to_date( {endDate}, 'yyyy-MM-dd hh24:mi:ss' )
                                                                                                   )where f_error_msg is not null



            ) a
                LEFT JOIN ( SELECT * FROM T_USERMESSAGE WHERE F_ISOPENACCOUNT IS NOT NULL ) B ON a.f_meternumber = b.f_meternumber
    )
WHERE
    {condition}
  AND f_meternumber IS NOT NULL and f_userinfo_id is not null
ORDER BY
    F_INSERT_DATE