select
    st.f_residential_area,
    st.f_distinct,
    st.f_opera_area,
    st.f_street,
    f_meter_classify,
    qzbul,
    builunm,
    usernum,
    bglnum,
    fbglnum,
    zcnum,
    tynum,
    ccnum
from (
         select area.f_residential_area,
                ad.f_distinct,
                ad.f_opera_area,
                ad.f_street,
                count(distinct f_building)                                              builunm, --楼栋数量
                count(distinct f_user_id)                                               usernum,
                count(distinct case when st.f_price_name like '%锅炉阶梯%' then f_user_id end) bglnum,
                count(distinct case when st.f_price_name like '%民用阶梯%' then f_user_id end) fbglnum,
                count(distinct case when f_table_state = '正常' then f_user_id end)       zcnum,
                count(distinct case when f_table_state = '停用' then f_user_id end)       tynum,
                count(distinct case when f_table_state = '拆除' then f_user_id end)       ccnum
         from t_userfiles uf
                  left join t_user_address ad on uf.f_userinfo_id = ad.f_userinfo_id
                  left join t_area area on area.id = ad.f_residential_area_id
                  left join t_userinfo u on uf.f_userinfo_id = u.f_userinfo_id
                  left join t_gasbrand gb on gb.id=uf.f_gasbrand_id
                  left join (
             select *
             from t_stairprice
             where f_perform_date <= sysdate
               and f_end_date >= sysdate
               and f_state = '有效'
         ) st on to_char(st.f_price_id) = to_char(uf.f_price_id)
         where uf.f_table_state != '有误'
        and uf.f_user_type = '民用'
        and {condition}
         group by area.f_residential_area, --小区
             ad.f_distinct,         --行政区域
             ad.f_opera_area,       -- 运营区域
             ad.f_street
     ) st
         left join(
    select
        f_residential_area,
        f_distinct,
        f_opera_area,
        f_street,
        listagg ( f_meter_classify,'、') within group ( order by f_meter_classify) f_meter_classify
    from(
        select
        area.f_residential_area,
        ad.f_distinct,
        ad.f_opera_area,
        ad.f_street,
        nvl(f_meter_type,f_meter_classify) f_meter_classify
        from t_userfiles uf
        left join t_user_address ad on uf.f_userinfo_id = ad.f_userinfo_id
        left join t_area area on area.id = ad.f_residential_area_id
        left join t_userinfo u on uf.f_userinfo_id = u.f_userinfo_id
        left join t_gasbrand gb on gb.id=uf.f_gasbrand_id
        left join (
        select *
        from t_stairprice
        where f_perform_date <= sysdate
        and f_end_date >= sysdate
        and f_state = '有效'
        ) st on to_char(st.f_price_id) = to_char(uf.f_price_id)
        where uf.f_table_state != '有误'
        and uf.f_user_type = '民用'
        and {condition}
        group by area.f_residential_area,ad.f_distinct,ad.f_opera_area,ad.f_street,nvl(f_meter_type,f_meter_classify)
        ) s
    group by f_residential_area,f_distinct,f_opera_area,f_street
) mt on mt.f_residential_area = st.f_residential_area
    and mt.f_distinct=st.f_distinct
    and mt.f_opera_area=st.f_opera_area
    and mt.f_street=st.f_street
         left join(
    select
        f_residential_area,
        f_distinct,
        f_opera_area,
        f_street,
        case when count(distinct f_building) <= 1 then min(f_building)
             else min(f_building) || '、' || max(f_building)
            end qzbul
    from (
             select area.f_residential_area,
                    ad.f_distinct,
                    ad.f_opera_area,
                    ad.f_street,
                    f_building,
                    row_number() over (
                partition by area.f_residential_area,ad.f_distinct,ad.f_opera_area,ad.f_street
                order by to_number(regexp_substr(f_building,'[0-9]*[0-9]',1))
            ) mins,
                     row_number() over (
                partition by area.f_residential_area,ad.f_distinct,ad.f_opera_area,ad.f_street
                order by to_number(regexp_substr(f_building,'[0-9]*[0-9]',1)) desc
            ) maxs
             from t_userfiles uf
                      left join t_user_address ad on uf.f_userinfo_id = ad.f_userinfo_id
                      left join t_area area on area.id = ad.f_residential_area_id
                      left join t_userinfo u on uf.f_userinfo_id = u.f_userinfo_id
                      left join t_gasbrand gb on gb.id=uf.f_gasbrand_id
                      left join (
                 select *
                 from t_stairprice
                 where f_perform_date <= sysdate
                   and f_end_date >= sysdate
                   and f_state = '有效'
             ) st on to_char(st.f_price_id) = to_char(uf.f_price_id)
             where uf.f_table_state != '有误'
            and uf.f_user_type = '民用'
            and {condition}
            and f_building is not null
         ) mst
    where mins=1 or maxs=1
    group by f_residential_area,f_distinct,f_opera_area,f_street
) minbul on minbul.f_residential_area = st.f_residential_area
    and minbul.f_distinct=st.f_distinct
    and minbul.f_opera_area=st.f_opera_area
    and minbul.f_street=st.f_street
order by st.f_residential_area,st.f_distinct,st.f_opera_area,st.f_street