select nvl(ms.f_gas_area, '')      f_gas_area,
       nvl(ms.f_point_name, '')    f_point_name,
       nvl(ms.f_gasproperties, '') f_gasproperties,
       nvl(ms.f_distinct, '')      f_distinct,
       nvl(ms.f_street, '')        f_street,
       f_card_id,
       tablenum,
       pmbnum,
       wlnum,
       lcnum,
       glnum,
       scxnum,
       cynum,
       bfrsnum
from (select
             {group == $f_card_id$:
             $listagg(f_gas_area, ',') within group ( order by f_gas_area) f_gas_area ,$,
             group != $f_gas_area$:
             $to_char(wm_concat(distinct f_gas_area)) f_gas_area ,$ ,
             $f_gas_area ,$}
             {group == $f_card_id$:
             $listagg(f_point_name, ',') within group ( order by f_point_name) f_point_name ,$,
             group != $f_point_name$:
             $to_char(wm_concat(distinct f_point_name)) f_point_name ,$ ,
             $f_point_name ,$}
             { 1 == 1:$
                 regexp_replace(listagg(f_street, ',') within  group(order by f_street),  '([^,]+)(,\1)*(,|)', '\1\3') f_street,
                 regexp_replace(listagg(f_distinct, ',') within  group(order by f_distinct),  '([^,]+)(,\1)*(,|)', '\1\3') f_distinct,
                 regexp_replace(listagg(f_gasproperties, ',') within  group(order by f_gasproperties),  '([^,]+)(,\1)*(,|)', '\1\3') f_gasproperties,
             $,$$}
           {group != $f_card_id$:$ to_char(wm_concat(distinct f_card_id)) f_card_id , $,$f_card_id ,$}
             count(distinct f_user_id)                                        tablenum,
             count(distinct case when f_jb_type = '皮膜表' then f_user_id end)   pmbnum,
             count(distinct case when f_jb_type = '涡轮流量计' then f_user_id end) wlnum,
             count(distinct case when f_jb_type = '罗茨流量计' then f_user_id end) lcnum,
             nvl(sum(glnum), 0)                                               glnum,
             nvl(sum(scxnum), 0)                                              scxnum,
             nvl(sum(cynum), 0)                                               cynum,
             nvl(sum(bfrsnum), 0)                                             bfrsnum
      from NonCivilianCount_VIEW ts
      where {condition}
      group by {group}) ms
order by {condValue}