select * from (
  select
    c.*,
    info.f_userinfo_code,
    address.f_address,
    oldgb.F_METER_BRAND f_old_meterbrand,
    oldgm.f_meter_style f_old_meternmodel,
    newgb.F_METER_BRAND f_new_meterbrand,
    newgm.f_meter_style f_new_meternmodel,
    uf.f_gasproperties,
    uf.f_user_type,
    old_gb.f_meter_brand  old_meter_brand ,
    new_gb.f_meter_brand new_meter_brand,
    f_residential_area,
    f_building,
    f_unit,
    f_floor,
    f_room

  from t_changemeter c
    left join t_userinfo info
      on c.f_userinfo_id = info.f_userinfo_id
    left join t_userfiles uf on uf.f_userinfo_id = info.f_userinfo_id
    left join t_gasbrand old_gb on old_gb.id = c.f_gasbrand_id
    left join t_gasbrand new_gb on new_gb.id = c.F_NEWGASBRAND_ID
    left join t_user_address address
      on info.f_userinfo_id = address.f_userinfo_id
    left join (select F_METER_BRAND, id from T_GASBRAND) oldgb on oldgb.id = c.F_GASBRAND_ID
    left join (select F_METER_STYLE || F_TYPE f_meter_style, id from T_GASMODEL) oldgm
              on oldgm.id = c.F_GASMODEL_ID
    left join (select F_METER_BRAND, id from T_GASBRAND) newgb on newgb.id = c.F_NEWGASBRAND_ID
    left join (select F_METER_STYLE || F_TYPE f_meter_style, id from T_GASMODEL) newgm
              on newgm.id = c.F_NEWGASMODEL_ID
) t
where {condition}
order by f_operate_date desc
