--查询卡表收费的总数量
SELECT
    COUNT (ID) c,
    NVL (SUM(f_pregas), 0) f_gas,
    NVL (SUM(f_preamount), 0) f_money,
    NVL(SUM(billmoney), 0) billmoney
FROM
	(
		SELECT
			sell.*
		FROM
			(
                SELECT f_preamount,
                       f_pregas,
                       s.ID,
                       s.f_filiale,
                       s.f_outlets,
                       s.op_spot,
                       s.op_id,
                       nvl(bill.billmoney,0) billmoney
                FROM T_SELLINGGAS s
                         left join T_BILLDETAIL bill on bill.F_CHARGE_ID =  s.id  and f_bill_state !='打票失败'  and f_bill_state !='无效' and f_bill_state !='打票异常'
                WHERE f_state = '有效'
                  and s.f_type in ('物联网收费', '卡表收费', '发卡售气')
				AND s.f_operate_date >= TO_DATE (
		'{startDate} 00:00:00',
		'yyyy-mm-dd hh24:mi:ss'
	)
	AND s.f_operate_date <= TO_DATE (
		'{endDate} 23:59:59',
		'yyyy-mm-dd hh24:mi:ss'
	)
		AND { f_filiale != $$ : $ s.f_filiale = '{f_filiale}' $,
		f_filiale == $$ : $ 1 = 1 $,
		$$ }
	AND { f_outlets != $$ : $ s.f_outlets = '{f_outlets}' $,
	f_outlets == $$ : $ 1 = 1 $,
	$$ }
AND { op_id != $$ : $ s.op_id = '{op_id}' $,
 op_id == $$ : $ 1 = 1 $,
 $$ }
AND { op_spot != $$ : $ s.op_spot = '{op_spot}' $,
 op_spot == $$ : $ 1 = 1 $,
 $$ }
			) sell
	)