SELECT
    { item },
    SUM (c) c,
    SUM (f_pregas) f_pregas,
    SUM (f_preamount) f_preamount,
    SUM (f_collection) f_collection
FROM
    (
    --拿收费记录（不拿同一天冲正的记录）
    SELECT
    { item },
    COUNT (ID) c,
    nvl(SUM(f_pregas), 0) f_pregas,
    nvl(SUM(f_preamount), 0) f_preamount,
    nvl(SUM(f_collection), 0) f_collection
    FROM
    t_sellinggas
    WHERE
    f_state = '有效'
    AND 	{ condition }
    GROUP BY
    { item }
    ) s
GROUP BY
    { item }
ORDER BY
    { item }