SELECT
	f_operate_date,
	SUM (c) c,
	SUM (f_pregas) f_pregas,
	SUM (f_preamount) f_preamount,
	SUM (f_collection) f_collection
FROM
	(
		--拿收费记录（不拿同一天冲正的记录）
		SELECT
			TO_CHAR (
				f_operate_date,
				'yyyy-mm-dd'
			) AS f_operate_date,
			COUNT (ID) c,
			NVL (SUM(f_pregas), 0) f_pregas,
			NVL (SUM(f_preamount), 0) f_preamount,
			NVL (SUM(f_collection), 0) f_collection
		FROM
			t_sellinggas
		WHERE
			f_state = '有效'
		AND 	{ condition }
		GROUP BY
			f_operate_date
	) s
GROUP BY
	f_operate_date
ORDER BY
	f_operate_date