package com.aote.rs;

import com.aote.logic.LogicServer;
import org.hibernate.ScrollableResults;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.inject.Singleton;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;

/**
 * @author GaoChengLong Waki
 * @date 2018/12/20 10:04
 * 提供供差计算
 * 如果有抄表记录,却没有购气记录的用户,会导致该程序出错
 */
@Singleton
@Component
public class NewBuySubService {
    @Autowired
    public SessionFactory sessionFactory;
    /**
     * 购气记录以及抄表记录查询游标
     */
    private Session buySession, handSession;
    private ScrollableResults buySet, handSet;
    /**
     * 记录遍历执行了多少条购气记录 用于打印日志
     */
    private long buySetIndex;
    /**
     * 执行的两条SQL语句
     */
    //private final String BuySQL = "SELECT * FROM( SELECT f_user_id,to_date( to_char( f_operate_date, 'yyyy-mm-dd' ), 'yyyy-mm-dd' ) f_operate_date,sum(f_pregas) f_pregas FROM t_sellinggas  GROUP BY f_user_id,f_operate_date ) t_gas     ORDER BY f_user_id,f_operate_date",
    //        HandSQL = "SELECT f_user_id,f_hand_date,f_tablebase FROM t_handplan    ORDER BY f_user_id, f_hand_date";
    //oracle的sql
    //private final String BuySQL = "SELECT * FROM( SELECT f_user_id,to_date( to_char( f_operate_date, 'yyyy-mm-dd' ), 'yyyy-mm-dd' ) f_operate_date,sum(f_pregas) f_pregas FROM t_sellinggas where  f_user_id !=10012380  and f_state = '有效' and f_user_id  not in (select ts.f_user_id from T_SELLINGGAS ts,T_HANDPLAN th where ts.f_user_id = th.f_user_id and f_type = '超用收费' group by ts.f_user_id )  GROUP BY f_user_id,f_operate_date ) t_gas ORDER BY f_user_id,f_operate_date",
     //       HandSQL = "SELECT f_user_id,f_hand_date,f_tablebase FROM t_handplan where     f_user_id !=10012380    and f_user_id  not in (select ts.f_user_id from T_SELLINGGAS ts,T_HANDPLAN th where ts.f_user_id = th.f_user_id and f_type = '超用收费' group by ts.f_user_id )     ORDER BY f_user_id, f_hand_date";
    //sqlserver的sql
    private final String BuySQL = "SELECT * FROM( SELECT f_user_id,convert(date,f_operate_date) f_operate_date,sum(f_pregas) f_pregas FROM t_sellinggas where  f_user_id !=10012380  and f_state = '有效' and f_user_id  not in (select ts.f_user_id from T_SELLINGGAS ts,T_HANDPLAN th where ts.f_user_id = th.f_user_id and f_type = '超用收费' group by ts.f_user_id )  GROUP BY f_user_id,f_operate_date ) t_gas ORDER BY f_user_id,f_operate_date",
           HandSQL = "SELECT f_user_id,f_hand_date,f_tablebase FROM t_handplan where    f_user_id !=10012380    and f_user_id  not in (select ts.f_user_id from T_SELLINGGAS ts,T_HANDPLAN th where ts.f_user_id = th.f_user_id and f_type = '超用收费' group by ts.f_user_id )     ORDER BY f_user_id, f_hand_date";
    /**
     * 区间起始结束时间的毫秒值
     */
    private long startDate, endDate;
    /**
     * 规定时间段内总共有多少天
     */
    private long daysNumber = 0;
    /**
     * 区间时间段抄表总和值
     */
    private double handSum = 0;
    /**
     * 区间时间段购气总和值
     */
    private double buySum = 0;
    /**
     * 下一位用户的第一条抄表记录信息
     */
    private Record handLastUser = null;
    /**
     * 下一位用户的第一条购气记录信息
     */
    private Record buyGasLastUser = null;

    /**
     * 一天的毫秒数
     */
    private final long ONE_DAY_MSEC = 1000 * 60 * 60 * 24;
    private SimpleDateFormat si = new SimpleDateFormat("yyyy-MM-dd");
    //设置抄表的临时开始时间点，当第一次的抄表时间在时间段之内的话就把这个时间设置为传入的开始时间，
    //即以抄表为基础，
    private long handStartDate, handEndDate;
    //private  Date handStartDate = null;
    //设置抄表的临时街书点，当最后一次的抄表记录在时间段之内的话就把这段时间设置为传入的结束时间，
    //即以抄表为基础
    //private  Date hanadEndDate = null;
    //设置一个临时变量来存储用户的id 用来判断是否为当前用户，如果变化的话判断第一条起始时间是否在传入的区间内，
    private String tempUserid = "";

    //查单遍历几条
    int jishu = 0;
    /**
     * 修正系数无参情况下是 使用平均用气量(x)除以平均购气量(y)算下来的值(x/y=n),结果读法为   用气比购气多了n倍
     * 如果需要计算估计用气,则需要这段时间的购气量乘以n值
     *
     * @param ratio 比例值 最终结果会乘以该值返回
     * @return 获取修正系数
     */
    public double getFixedNum(double ratio, Date startDate, Date endDate) {
        // 对起始时间赋值
        this.startDate = startDate.getTime();
        //动态变化的抄表开始时间
        this.handStartDate = startDate.getTime();
        // 对结束时间赋值
        this.endDate = endDate.getTime();
        //动态变换的抄表结束时间
        this.handEndDate = endDate.getTime();
        //System.out.println("起始时间" + this.startDate);
        //System.out.println("结束时间" + this.endDate);
        //System.out.println(si.format(new Date(this.startDate)));
        //System.out.println(si.format(new Date(this.endDate)));
        if (ratio == 0) {
            ratio = 1;
        }
        double result;
        try {
            // 创建结果集，进行准备工作
            this.createScrollableResults();//创建两条游标（购气游标）（抄表游标）
            // 运算过程
            result = this.getFixedNum();
        } catch (Exception e) {
            e.printStackTrace();
            return 0;
        } finally {
            // 销毁结果集
            this.destroyClassVariate();
        }
        return result * ratio;
    }

    /**
     * 运算过程
     *
     * @return 并没有用最终结果除以天数哦
     */
    private double getFixedNum() {
        // 计算区间内有多少天
        this.daysNumber = (this.endDate - this.startDate) / this.ONE_DAY_MSEC;
        //System.out.println("区间内有:" + this.daysNumber + "天");
        // 跳出循环条件
        boolean isForLoop = true;
        // 循环一次，一个用户的规定时间段内的差值计算出来了
        while (isForLoop) {
            // 用户的第一个抄表记录
            Record record = null, record2 = null;//Record保存一条抄表 或 购气记录
            // 是否有下一位用户的第一条抄表信息
            // null等于没有
            //第一次进来的时候没有值，将第一条抄表记录给他
            if (handLastUser == null) {
                record = new Record(handSet);//setPrame方法向下移动填充记录
                //System.out.println(record.toString());//打印当前对象
            } else {//当有值得话，则
                record = handLastUser;        //
                handLastUser = null;
            }
            // 记录填充成功
            if (record.isEnd) {
                // 获取下一条抄表记录 并且与该抄表记录进行关联
                record2 = new Record(record, handSet);
                //System.out.println("record2"+record2.toString());
                // 进入到该判断则代表填充完成，并且成功关联
                if (record2.isEnd && record2.last != null) {
                    // 获取到了一位用户已经构成区间的抄表记录(不一定为规定区间值)，现在去获取该用户的详细并且有效的区间值
                    // 返回所有存在规定区间内的值
                    List<TimeAverage> times = this.scopeTime(record2, true);
                    //System.out.println(times.size());
//                    for(TimeAverage temp:times){
//                        System.out.println("查到的区间的值"+temp.toString());
//                    }
                    // 去拿这些有用的抄表记录去与存在于规定区间内的购气记录去计算
                    this.compute(record2, times);
                } else {
                    // 只有一条抄表记录，所以不可能再进行计算，出现这种情况的只有是新建档案的才抄一次的 除非再查询建档日期，否则毫无意义
                    // 这时候，由于游标不回滚，故此保存已读出来的下一位用户的抄表信息,另外，只有一条抄表记录，不能为供差值提供帮助
                    handLastUser = record2;
                }
            } else {
                //连下一个用户的抄表记录都填不上了，那肯定是抄表记录没了呗
                isForLoop = false;
            }
        }
        System.out.println("抄表量:" + this.handSum + "方");
        System.out.println("购气量:" + this.buySum + "方");
        System.out.println("查看到底多少条有效"+jishu);
        return new BigDecimal((this.handSum / this.buySum)).setScale(6, BigDecimal.ROUND_HALF_UP).doubleValue();
    }

    /**
     * 计算与正确区间时间内的抄表记录对应的购气记录两者之间的供差值
     *
     * @param record 单一用户对象
     * @param hand   该用户的抄表记录
     */
    private void compute(Record record, List<TimeAverage> hand) {
        String userid = record.userid;
        Record buyUser = null;
        //handLastUser 值为空，或，handLastUser中的 isEnded字段为假则把下一个购气记录给这个
        if (this.handLastUser == null || !this.handLastUser.isEnd) {
            buyUser = new Record(buySet);
            //判断这个值是否为空，为空则把当前对象的userid赋值，避免后面获取的时候空指针
            if(buyUser.userid == null){
                buyUser.userid = userid;
            }
        } else {
            buyUser = this.handLastUser;
            this.handLastUser = null;
        }
        // 判断购气记录当前用户是否对应当前抄表用户
        //System.out.println("查看到底什么导致空指针");
        //第一个值的userid为空
        //System.out.println(buyUser.userid);
        //System.out.println(userid);
        if (!buyUser.userid.equals(userid)) {
            // 并不对应,刷新到当前抄表用户
            buyUser = this.getBuyGasUser(record, false);
        }
        // 获取关联的购气记录
        buyUser = new Record(buyUser, false);
        // 关联的购气记录值成功
        if (buyUser.last != null && buyUser.isEnd) {
            // 获取规定时间内的详细购气记录
            List<TimeAverage> buy = this.scopeTime(buyUser, false);//计算购气记录的值
            //判断，取抄表和购气的交集，避免抄表记录有，但是购气记录无
            //如何判断呢，取购气的最后一条，循环判断抄表是否在内，否则删除溢出的抄表记录
//            if(hand.size()>0 && buy.size()>0) {
//                for (int i = 0; i < hand.size() - 1; i++) {
//                    if (hand.get(i).endDate > buy.get(buy.size() - 1).endDate) {
//                        System.out.println("删除几次==========================");
//                        hand.remove(i);
//                    }
//                    //System.out.println("查到的hand抄表区间的值"+temp.toString());
//                }
//            }
            Iterator<TimeAverage> it = hand.iterator();
            if(hand.size()>0 && buy.size()>0) {
                while (it.hasNext()) {
                    //System.out.println("查看最后一个购气的值"+buy.get(buy.size() - 1).endDate);
                    if (it.next().endDate > buy.get(buy.size() - 1).endDate) {
                        //System.out.println("删除几次++++++++++++++++++");
                        it.remove();
                    }
                }
            }
//            for(TimeAverage temp:hand){
//                System.out.println("查看调整后的抄表记录"+temp.toString());
//            }
//            for(TimeAverage temp:buy){
//                System.out.println("查看调整后的购气记录"+temp.toString());
//            }
            // 因为传入数据(SQL)的特性，同等类型的区间记录与记录之间，不会有交集，整体数据的时间是呈线性
            // 某位用户的购气记录可能为0
            if (hand.size() == 0 || buy.size() == 0) {
                return;
            }


            // 计算规定时间内的购气量和用气量
            jishu++;
            for(TimeAverage tem :hand){
                System.out.println("有效的抄表值"+tem.toString());
            }
            for (TimeAverage tep :buy){
                System.out.println("有效的购气值"+tep.toString());
            }
            this.handSum += this.sumGas(hand);
            this.buySum += this.sumGas(buy);
        }
        //如果进不去,就代表着当前用户没有第二条购气记录或者结果集已经走到头了,so 没办法计算喽
    }

    /**
     * @param items 计算该区间记录中的与规定时间交集的时间中的气量总和
     * @return 总和值
     */
    private double sumGas(List<TimeAverage> items) {
        // 返回用总购气量
        double sumValue = 0.0;
        // 当前时间戳
        long date = this.startDate;
        // 当前执行到的天数
        long day = 0;
        // 当前执行的times下标值
        int index = 0;
        // 合并重复值
        items = this.mergeRepetition(items);
        // 上一条记录
        TimeAverage item = null;
        while (index < items.size()) {
            if (day > this.daysNumber) {
                break;
            }
            date = this.startDate + (day * this.ONE_DAY_MSEC);
            // 当前记录的结束时间是否大于当前时间 如果大于则进入判断
            item = items.get(index);
            // 该条记录与当前执行时间交集
            if (item.startDate <= date && item.endDate >= date) {
                sumValue += item.getAverageValue();
                if (!((index + 1) < items.size() && items.get(index + 1).endDate == date)) {
                    day++;
                } else {
                    index++;
                }
            } else if (item.startDate > date) {
                day++;
            } else {
                index++;
            }
        }
        return sumValue;
    }

    /**
     * 合并日期重复的值
     */
    private List<TimeAverage> mergeRepetition(List<TimeAverage> items) {
        // 只有一条记录的怎么筛重复嘛,还不原路返回去
        if (items.size() == 1) {
            return items;
        }
        List<TimeAverage> rollBack = new ArrayList<>();
        TimeAverage item = items.get(0);
        for (int i = 1; i < items.size(); i++) {
            if (!items.get(i).isValid()) {
                continue;
            }
            // 上一个对象的时间值和下一个对象的时间值是一样的
            if (item.startDate == items.get(i).startDate && item.endDate == items.get(i).endDate) {
                // 相同数据 合并操作
                double startValue, endValue;
                // 抄表合并
                if (item.type) {
                    startValue = item.startValue;
                    endValue = items.get(i).endValue;
                    item = new TimeAverage(item.startDate, item.endDate, item.userid, item.day, (endValue - startValue), startValue, endValue, item.type);
                } else {
                    // 购气合并
                    startValue = item.startValue;
                    endValue = items.get(i).startValue + items.get(i).endValue;
                    item = new TimeAverage(item.startDate, item.endDate, item.userid, item.day, (startValue + endValue), startValue, endValue, item.type);
                }

                if ((i + 1) == items.size()) {
                    rollBack.add(item);
                }
            } else {
                rollBack.add(item);
                // 如果get(i)是最后一位了,那就直接加到返回值上面然后返回吧。
                if (i == (items.size() - 1)) {
                    rollBack.add(items.get(i));
                    break;
                }
                item = items.get(i);
            }
        }
        return rollBack;
    }

    /**
     * 获取两条以上记录的用户的抄表/购气存在区间中的信息
     * 该方法执行完成之后,获得的区间记录对象一定是【一个用户】在规定时间内的交集记录对象
     *
     * @param record 关联了正确的last的Record
     * @param type   决定是抄表 true/购气记录 false
     * @return 存在规定区间中的记录信息
     */
    private List<TimeAverage> scopeTime(Record record, boolean type) {
        List<TimeAverage> list = new ArrayList();
        //定义一个标志，来判断是否需要变化区间
        String gc = "";
        //判断这个时间段内是否有抄表记录 让传入的时间进入抄表的区间
        int i = 0;

        //如果userid变化则变成原始时间，否则购气也按照抄表的时间段进行
        if(!record.userid.equals(tempUserid)){
            this.startDate = this.handStartDate;
            this.endDate = this.handEndDate;
            tempUserid = record.userid;
        }
        // 获取规定区间内的平均值 当last!=null也就代表依旧是同一个用户
        while (record.isEnd && record.last != null) {
            TimeAverage time = null;
            //第一条抄表的时间小于传入的开始时间，第二条抄表的时间大于传入的开始时间，第二条开始时间小于等于传入的结束时间
            if (record.last.dateTime < this.startDate && record.dateTime > this.startDate && record.dateTime <= this.endDate) {
                i++;
                // 记录时间在起始时间之前，但结束时间，在规定结束时间之内
                time = new TimeAverage(record.last.dateTime, record.dateTime, record.userid, type, record.last.gasNum, record.gasNum);
            } else if (record.last.dateTime < this.startDate && record.dateTime >= this.endDate) {
                i++;
                // 记录时间在起始时间之前但结束时间在规定结束时间之外,相当于只用一条记录区间数据
                time = new TimeAverage(record.last.dateTime, record.dateTime, record.userid, type, record.last.gasNum, record.gasNum);
                list.add(time);
                record = this.nextUser(record, type);
                break;
            } else if (record.last.dateTime >= this.startDate && record.last.dateTime < this.endDate) {
                // 起始时间大于或者等于规定起始时间并且小于结束时间
                //当第一天抄表属于这个区间的话那么就改变当前的区间
                if(i==0 && type){
                    this.startDate = record.last.dateTime;
                    i++;
                }
                //System.out.println(this.startDate);
                //System.out.println(si.format(new Date(this.startDate)));
                time = new TimeAverage(record.last.dateTime, record.dateTime, record.userid, type, record.last.gasNum, record.gasNum);
            }
            if (time != null) {
                // 区间创建成功 list存放对象
                list.add(time);
            }
            // 获取下一条区间值
            //查看这条记录的用户和气量
            if(type){
                gc = "抄表";
            }else{
                gc = "购气";
            }

            //System.out.println("   这条记录的时间:"+record.dateTime);
            //System.out.println(gc+"气量:"+record.gasNum);
            //System.out.println(gc+"上一个的气量:"+record.last.gasNum);

            //根据type的类型判断是抄表还是购气，之后new一个新的record
            record = new Record(record, type ? handSet : buySet);
            //System.out.println("下一个新的对象"+record.toString());
        }
        if (type) {
            this.handLastUser = record;
        } else {
            this.buyGasLastUser = record;
        }
        return list;
    }

    /**
     * 刷新到下一条用户的记录
     *
     * @param record 本次用户
     * @param type   购气还是抄表记录
     * @return 传入用户的下一位用户
     */
    private Record nextUser(Record record, boolean type) {
        String userid = record.userid;
        ScrollableResults scroll = type ? handSet : buySet;
        while (record.isEnd && record.userid.equals(userid)) {
            // 获取下一条记录
            record = new Record(record, scroll);
        }
        return record;
    }

    /**
     * 将记录的游标刷新到同用户
     *
     * @param record 目标用户
     * @param type   购气还是抄表
     * @return 同用户的游标
     */
    private Record getBuyGasUser(Record record, boolean type) {
        String userid = record.userid;
        ScrollableResults scroll = type ? handSet : buySet;
        do {
            record = new Record(record, scroll);
        } while (record.isEnd && !record.userid.equals(userid));
        return record;
    }

    /**
     * 对类变量创建两个SQL的结果集
     */
    private void createScrollableResults() {
        this.handSet = createScrollableResult(true, this.HandSQL);
        this.buySet = createScrollableResult(false, this.BuySQL);
    }

    /**
     * @return 创建单个SQL结果集
     */
    private ScrollableResults createScrollableResult(boolean bol, String SQL) {
        Session session = sessionFactory.openSession();
        // 根据boolean来决定是给抄表赋值还是购气赋值 true是抄表 false是购气
        if (bol) {
            this.handSession = session;
        } else {
            this.buySession = session;
        }
        return session.createSQLQuery(SQL).scroll();
    }

    /**
     * 销毁结果集和Session
     */
    private void destroyClassVariate() {
        if (this.handSet != null) {
            this.handSet.close();
        }
        if (this.buySet != null) {
            this.buySet.close();
        }
        if (this.handSession != null) {
            this.handSession.close();
        }
        if (this.buySession != null) {
            this.buySession.close();
        }
    }

    /**
     * 单元测试方法
     */
    public void junitTest() {
       Double dou =  this.getFixedNum(1, new Date(1542816000000L - ((1000L * 60L * 60L * 24L) * 10)), new Date(1542816000000L + ((1000L * 60L * 60L * 24L) * 10)));
        //System.out.println("查看一下值"+dou);
    }

    public static void main(String[] args) {
//        2420.2270308123234
//        21997.87323448915
//        new BigDecimal((this.handSum / this.buySum)).setScale(6).doubleValue()
        //System.out.println(new BigDecimal(2420.2270308123234 / 21997.87323448915));
        //System.out.println(new BigDecimal(2420.2270308123234 / 21997.87323448915).setScale(6, BigDecimal.ROUND_HALF_UP).doubleValue());
    }

    /**
     * 该对象保存了一条抄表或者购气气量的记录
     */
    private class Record {
        /**
         * 表编号
         */
        public String userid;
        /**
         * 时间戳
         */
        public long dateTime;
        /**
         * 气量 购气气量/抄表气量
         */
        public double gasNum;
        /**
         * 对象类型 该对象是购气量对象还是抄表对象
         * true是抄表 false是购气
         */
        public boolean type;
        /**
         * 上一次购气量的对象
         */
        public Record last;
        /**
         * 对象是我们手动new出来的,所以不会存在Record==null之说
         * 故此添加一个变量来决定该对象是否被成功填值
         * 默认是false则代表未成功填值
         */
        public boolean isEnd = false;

        /**
         * 新建一个记录对象
         */
        public Record(ScrollableResults results) {
            this.getRecord(results);
        }

        @Override
        public String toString() {
            return "Record{" +
                    "userid='" + userid + '\'' +
                    ", dateTime=" + dateTime +
                    ", gasNum=" + gasNum +
                    ", type=" + type +
                    ", last=" + last +
                    ", isEnd=" + isEnd +
                    '}';
        }

        public Record(Record record, boolean type) {
            record.last = null;
            this.getRecord(record, type ? handSet : buySet);
        }

        /**
         * 创建一个关联记录对象,该对象的上次购气量指向了上一条记录
         * 如果传入的Record为空，则创建一个无关联对象
         * 如果传入的Record的userId不等于新产生的userId则不对新产生的对象的last赋值
         */
        public Record(Record record, ScrollableResults results) {
            // 释放掉上一个记录的对象，以防万一内存溢出
            record.last = null;
            this.getRecord(record, results);
        }

        private void getRecord(Record record, ScrollableResults results) {
            if (record == null) {
                getRecord(results);
                return;
            }
            getRecord(results);
            // 当userId与上一个记录相同时，对对象进行关联
            if (this.isEnd && record.userid.equals(this.userid)) {
                this.last = record;
            }
        }

        private void getRecord(ScrollableResults results) {
            if (results == buySet) {
                // 如果传入对象的内存地址与购气结果集的对象相同，则该对象是购气记录
                this.type = false;
            } else if (results == handSet) {
                // 否则则是抄表记录
                this.type = true;
            }
            // 对当前对象填值
            this.setParam(this, results);
        }

        /**
         * 给当前对象填值
         */
        private void setParam(Record record, ScrollableResults results) {
            if (results.next()) {
                Object[] obj = results.get();
                // 已避免空指针异常，如果某项值有null值,则该对象填充失败
                // 表编号
                if (obj[0] != null) {
                    record.userid = obj[0].toString();
                    // 抄表时间/购气时间
                    if (obj[1] != null) {
                        record.dateTime = ((Date) obj[1]).getTime();
                        // 抄表气量/购气气量
                        if (obj[2] != null) {
                            record.gasNum = ((BigDecimal) obj[2]).doubleValue();
                            // 该变量数据填充完毕
                            record.isEnd = true;
                            if (results == buySet) {
                                if (buySetIndex % 100000 == 0) {
                                    //System.out.println("购气记录已遍历:" + buySetIndex + "条");
                                }
                                // 购气记录下标++ 用于记录以及显示进度
                                buySetIndex++;
                            }
                        }
                    }
                }

            } else {
                record.isEnd = false;
            }
        }
    }

    /**
     * 一位用户某个区间段的值数据
     */
    private class TimeAverage {
        /**
         * 起始时间
         */
        private long startDate;
        /**
         * 结束时间
         */
        private long endDate;
        /**
         * 起始值
         */
        private double startValue;
        /**
         * 结束值
         */
        private double endValue;
        /**
         * 用户表编号
         */
        private String userid;
        /**
         * 区间时间
         */
        private long day;
        /**
         * 区间平均值
         */
        private double averageValue;
        /**
         * 区间类型
         * true是抄表 false是购气
         */
        public boolean type;

        @Override
        public String toString() {
            return "TimeAverage{" +
                    "startDate=" + si.format(startDate) +
                    ", endDate=" + si.format(endDate) +
                    ", startValue=" + startValue +
                    ", endValue=" + endValue +
                    ", userid='" + userid + '\'' +
                    ", day=" + day +
                    ", averageValue=" + averageValue +
                    ", type=" + type +
                    ", isValid=" + this.isValid() +
                    "}\n";
        }

        public TimeAverage(long startDate, long endDate, String userid, long day, double averageValue, double startValue, double endValue, boolean type) {
            setParam(startDate, endDate, userid, day, averageValue, startValue, endValue, type);
        }

        public TimeAverage(long startDate, long endDate, String userid, boolean type, double startNum, double endNum) {
            // Java特性,如果使用整数型去做除法,会直接丢弃小数值,所以,直接判断是否小于1吧
            long days = ((endDate - startDate) / ONE_DAY_MSEC);
            if (days < 1) {
                // 是在同一天
                // 判断是抄表还是购气
                if (type) {
                    // 抄表的话，用右边时段的气量减去左边时段的气量
                    //判断如果右边气量小于左边气量的话，说明这条记录是换表或者记录错误，丢弃
                    if(startNum<=endNum){
                        setParam(startDate, endDate, userid, 0, endNum - startNum, startNum, endNum, type);
                    }

                } else {
                    // 购气的话，两边购气量一相加等于一天的购气量   有问题！（修正 如果为同一天则相加！）
                    setParam(startDate, endDate, userid, 0, startNum + endNum, startNum, endNum, type);
                    //setParam(startDate, endDate, userid, 0, startNum, startNum, endNum, type);
                }
            } else {
                // 不是同一天
                // 判断是抄表还是购气
                if (type) {
                    // 计算区间抄表平均值
                    //判断如果左边气量小于右边气量的话，说明这条记录是换表或者记录错误，丢弃
                    if(startNum<=endNum) {
                        double average = (endNum - startNum) / days;
                        setParam(startDate, endDate, userid, days, average, startNum, endNum, type);
                    }
                } else {
                    // 计算区间购气平均值 （有问题，当最后一条记录在输入的时间内，前一条在输入的时间外，只会计算两个时间段的平均值，应该再加上这次的购气记录才对！）
                    //
                    double average = startNum / days;
                    setParam(startDate, endDate, userid, days, average, startNum, endNum, type);
                }
            }
        }

        private void setParam(long startDate, long endDate, String userid, long day, double averageValue, double startValue, double endValue, boolean type) {
            this.startDate = startDate;
            this.endDate = endDate;
            this.userid = userid;
            this.day = day;
            this.averageValue = averageValue;
            this.type = type;
            this.startValue = startValue;
            this.endValue = endValue;
        }

        public long getStartDate() {
            return startDate;
        }

        public long getEndDate() {
            return endDate;
        }

        public String getUserid() {
            return userid;
        }

        public long getDay() {
            return day;
        }

        public double getAverageValue() {
            return averageValue;
        }

        public boolean isType() {
            return type;
        }

        public boolean isValid() {
            return this.averageValue < 0 ? false : true;
        }
    }
}
