SELECT
	*
FROM
	(
		SELECT
			U .*, address.f_address,
			address.f_slice_area,
			info.f_userinfo_code,
			info.f_user_name,
			gb.f_meter_brand,
			gm.f_meter_style,
			sp.f_price_type,
			sp.f_price_name,
			de.f_devices_type
		FROM
			t_userfiles U
		LEFT JOIN t_user_address address ON U .f_useraddress_id = address. ID
	    LEFT JOIN t_devices de ON de.f_user_id = U. f_user_id
		LEFT JOIN t_userinfo info ON U .f_userinfo_id = info.f_userinfo_id
		LEFT JOIN t_gasbrand gb ON U .f_gasbrand_id = gb. ID
		LEFT JOIN t_gasmodel gm ON U .f_gasmodel_id = gm. ID
		LEFT JOIN t_stairprice sp ON U .f_price_id = sp.f_price_id
		AND sp.f_state = '有效'
		AND { entity.findDialect () == $SqlServer$ : $getdate () $,
		$SYSDATE$ }>= f_perform_date
		AND { entity.findDialect () == $SqlServer$ : $getdate () $,
		$SYSDATE$ } <= f_end_date
	) T
WHERE
	{condition}
ORDER BY
	f_user_id DESC