select * from (
	SELECT
	  h.*,
		u.f_user_phone,
		u.f_residential_area,
		u.f_user_state,
		u.f_userinfo_code,
		h.f_oughtfee - ISNULL(s.f_debt_money, 0) - ISNULL(s.f_credit_amount, 0) real_charge --清缴减免后的应缴金额
	FROM t_handplan h
	LEFT JOIN  t_userinfo u ON h.f_userinfo_id = u.f_userinfo_id
  LEFT JOIN (
    SELECT
      f_hand_id,
      SUM (f_debt_money) f_debt_money,
		  SUM (f_credit_amount) f_credit_amount
    FROM
      t_sellinghand
    WHERE
      f_charge_state = '有效'
    GROUP BY
      f_hand_id
  ) s ON h.id = s.f_hand_id
) handplan
WHERE
  {condition}
ORDER BY
  f_hand_date desc
