SELECT
*
FROM
	(
		SELECT
			T_SERVICEWORKORDER.*, b.user_name,
			b.user_link,
			b.road,
			b.unit_name,
			b.cus_dy,
			b.cus_dom,
			b.cus_floor,
			b.cus_room,
			b.f_wire_front,
			b.f_wire_back,
			b.f_strapping_table,
			b.f_table_card,
			b.f_number_table,
			b.card_id,
			b.jb_table_code,
			b.jb_type,
			b.f_gas_direction,
			b.f_gas_age,
			b.f_package,
			b.f_old_number,
			b.f_jibiao_base,
			b.f_ictype,
			b.f_allbuy_gas,
			b.f_overplus_gas,
			b.f_overplus_money,
			b.f_new_number,
			b.userlevel_type,
			D .f_reason_change,
			D .f_result_change,
			D .f_type_change,
			D .f_old_type,
			D .f_old_id,
			D .f_old_backnumber,
			D .f_old_overplus,
			D .f_new_type,
			D .f_new_backnumber,
			D .f_new_id,
			D .f_freereason,
			D .f_shiftgas_type,
			D .f_change_cost,
			D .f_shiftgas,
			D .f_shiftgas_money,
			D .f_overgas,
			D .f_deductgas,
			D .f_addgas,
			D .f_if_gasbill,
			D .f_gasbill,
			D .f_gas_schedule,
			T_SERVICE.f_repair_date,
			sa.*,
			li.*,
			ga.*,
			s.f_content,
			f.failurerepair,
			w. ID wid,
			w.f_date_leave,
			actes.DEFNAME
		FROM
			T_SERVICEWORKORDER
		LEFT JOIN T_SERVICE ON T_SERVICEWORKORDER.F_SERVICE_ID = T_SERVICE.F_SERVICE_ID
		LEFT JOIN (
			SELECT
				*
			FROM
				T_SERVICEWORK
			WHERE
				ID IN (
					SELECT
						MAX (ID)
					FROM
						T_SERVICEWORK
					GROUP BY
						serviceid
				)
		) w ON T_SERVICEWORKORDER. ID = w.SERVICEID
		LEFT JOIN T_BASEUSERINFO b ON b. ID = w. ID
		LEFT JOIN T_DOORREPAIR D ON D .serviceid = w. ID
		LEFT JOIN (
			SELECT
				serviceid gid,
				f_method g_method,
				f_high g_hight,
				f_result g_result,
				f_position g_position,
				f_complement g_complement,
				f_men_team g_team,
				f_men g_men,
				f_remarks g_remarks
			FROM
				T_GAICONDUIT
		) ga ON ga.gid = w. ID
		LEFT JOIN (
			SELECT
				serviceid lid,
				f_li_type,
				f_change,
				f_result l_result,
				f_position l_position,
				f_men_team l_team,
				f_men l_men,
				f_remarks l_remarks
			FROM
				T_LICONDUIT
		) li ON li.lid = w. ID
		LEFT JOIN (
			SELECT
				serviceid said,
				f_meter_position,
				f_li_result,
				f_is_open,
				f_result s_result,
				f_men_team s_team,
				f_men s_men,
				f_remarks s_remarks
			FROM
				T_RETAIL
		) sa 
		ON sa.said = w. ID
		LEFT JOIN (
			SELECT
				SID,
				listagg (
					TYPE || ' :' || f_project || ':' || f_content || '' || f_contentmessage || ';' || '',
					''
				) WITHIN GROUP (ORDER BY SID) failurerepair
			FROM
				(
					SELECT
						s.serviceid SID,
						s.f_type TYPE,
						D .*
					FROM
						t_details D
					LEFT JOIN t_servicerepair s ON D .f_service_id = s. ID
				) s
			GROUP BY
				SID
		) f ON f. SID = w. ID
		LEFT JOIN (
			SELECT
				F_SERVICE_ID,
				f_content
			FROM
				T_CONSULT
			UNION
				SELECT
					F_SERVICE_ID,
					f_content
				FROM
					T_COMPLAINT
		) s ON s.F_SERVICE_ID = T_SERVICEWORKORDER.F_SERVICE_ID
		LEFT JOIN (
			SELECT
				*
			FROM
				ACTIVITYINS
			WHERE
			id = any(
					SELECT
						MAX (ID)
					FROM
						ACTIVITYINS
					GROUP BY
						PROCESSID
				)
		) actes ON actes.PROCESSID = T_SERVICE.F_PROCESSID
	) r
WHERE
	{condition} and f_workorder_type='报修单'
ORDER BY
	ID