/*
 * Decompiled with CFR 0.152.
 */
package com.af.util;

import java.io.IOException;
import java.io.InputStream;

public class ByteHelper {
    public static int getInteger(InputStream ast) throws IOException {
        byte[] bytes = new byte[4];
        ast.read(bytes);
        return (bytes[0] << 24) + (bytes[1] << 16) + (bytes[2] << 8) + bytes[3];
    }

    public static int getInteger8(InputStream ast) throws IOException {
        byte[] bytes = new byte[8];
        ast.read(bytes);
        return (bytes[4] << 24) + (bytes[5] << 16) + (bytes[6] << 8) + bytes[7];
    }

    public static double getDouble(InputStream ast) throws Exception {
        int sgn;
        byte[] bytes = new byte[8];
        ast.read(bytes);
        int e = ((bytes[0] & 0x7F) << 4) + ((bytes[1] & 0xF0) >> 4);
        e -= 1023;
        long l1 = (long)(bytes[1] & 0xF) << 48;
        long l2 = (long)bytes[2] << 40;
        long l3 = (long)bytes[3] << 32;
        long l4 = (long)bytes[4] << 24;
        long l5 = (long)bytes[5] << 16;
        long l6 = (long)bytes[6] << 8;
        long l7 = bytes[7];
        long p = l1 + l2 + l3 + l4 + l5 + l6 + l7;
        double mant = 1.0 + (double)p / Math.pow(2.0, 52.0);
        int n = sgn = (bytes[0] & 0x80) == 0 ? 1 : -1;
        if (e == 1024 && mant == 1.0) {
            return sgn == 1 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        }
        if (e == 1024 && mant != 0.0) {
            return Double.NaN;
        }
        if (e == -1023) {
            return (double)sgn * Math.pow(2.0, -1022.0) * (mant - 1.0);
        }
        return (double)sgn * Math.pow(2.0, e) * mant;
    }
}

