/*
 * Decompiled with CFR 0.152.
 */
package com.af.func;

import com.af.func.Delegate;
import com.af.func.IExpression;
import com.af.util.ByteHelper;
import com.af.util.TwoTuple;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;

public class Expression {
    public static IExpression from(InputStream ast) throws Exception {
        int type = ast.read();
        switch (type) {
            case 1: {
                List<IExpression> statement = Expression.getExps(ast);
                IExpression exp = Expression.statement(statement);
                return exp;
            }
            case 2: {
                IExpression body = Expression.from(ast);
                List<IExpression> statement = Expression.getExps(ast);
                return Expression.call(body, statement);
            }
            case 3: {
                int result = ByteHelper.getInteger8(ast);
                IExpression exp = Expression.constant(result);
                return exp;
            }
            case 4: {
                double d = ByteHelper.getDouble(ast);
                IExpression exp = Expression.constant(new BigDecimal(d));
                return exp;
            }
            case 5: {
                return Expression.concat(Expression.from(ast), Expression.from(ast));
            }
            case 6: {
                return Expression.constant(Expression.getString(ast));
            }
            case 7: {
                String op = Expression.getString(ast);
                return Expression.math(op, Expression.from(ast), Expression.from(ast));
            }
            case 8: {
                return Expression.array(Expression.getExps(ast));
            }
            case 9: {
                int len = ByteHelper.getInteger(ast);
                LinkedList<IExpression> attrs = new LinkedList<IExpression>();
                for (int i = 0; i < len; ++i) {
                    IExpression attr = Expression.attr(Expression.getString(ast), Expression.from(ast));
                    attrs.add(attr);
                }
                return Expression.json(attrs);
            }
            case 10: {
                return Expression.property(Expression.from(ast), Expression.getString(ast));
            }
            case 11: {
                return Expression.func(Expression.getString(ast), Expression.getStrings(ast), Expression.from(ast));
            }
            case 12: {
                return Expression.funcName(Expression.getString(ast));
            }
            case 13: {
                throw new RuntimeException("\u4e0d\u652f\u6301\u5916\u90e8\u51fd\u6570\u8c03\u7528");
            }
            case 14: {
                return Expression.mod(Expression.getString(ast), Expression.from(ast));
            }
            case 15: {
                return Expression.compare(Expression.getString(ast), Expression.from(ast), Expression.from(ast));
            }
            case 16: {
                return Expression.not(Expression.from(ast));
            }
            case 17: {
                return Expression.logic(Expression.getString(ast), Expression.from(ast), Expression.from(ast));
            }
            case 18: {
                return Expression.condition(Expression.getConditions(ast), Expression.from(ast));
            }
            case 19: {
                return Expression.modCall(Expression.getString(ast), Expression.getString(ast));
            }
        }
        throw new RuntimeException("\u65e0\u6b64\u7c7b\u578b");
    }

    public static List<IExpression> getExps(InputStream ast) throws Exception {
        int len = ByteHelper.getInteger(ast);
        LinkedList<IExpression> statement = new LinkedList<IExpression>();
        for (int i = 0; i < len; ++i) {
            IExpression exp = Expression.from(ast);
            statement.add(exp);
        }
        return statement;
    }

    public static List<Object> getStrings(InputStream ast) throws Exception {
        int len = ByteHelper.getInteger(ast);
        LinkedList<Object> statement = new LinkedList<Object>();
        for (int i = 0; i < len; ++i) {
            String str = Expression.getString(ast);
            statement.add(str);
        }
        return statement;
    }

    public static List<TwoTuple<IExpression, IExpression>> getConditions(InputStream ast) throws Exception {
        int len = ByteHelper.getInteger(ast);
        LinkedList<TwoTuple<IExpression, IExpression>> statement = new LinkedList<TwoTuple<IExpression, IExpression>>();
        for (int i = 0; i < len; ++i) {
            statement.add(new TwoTuple<IExpression, IExpression>(Expression.from(ast), Expression.from(ast)));
        }
        return statement;
    }

    public static String getString(InputStream ast) throws Exception {
        int len = ByteHelper.getInteger(ast);
        byte[] bytes = new byte[len];
        ast.read(bytes);
        return new String(bytes);
    }

    public static IExpression math(final String op, final IExpression left, final IExpression right) {
        return new IExpression(){

            @Override
            public Object invoke(Delegate del) {
                Object oLeft = left.invoke(del);
                Object oRight = right.invoke(del);
                if (oLeft instanceof BigDecimal || oRight instanceof BigDecimal) {
                    BigDecimal l = new BigDecimal(oLeft.toString());
                    BigDecimal r = new BigDecimal(oRight.toString());
                    switch (op) {
                        case "+": {
                            return l.add(r);
                        }
                        case "-": {
                            return l.subtract(r);
                        }
                        case "*": {
                            return l.multiply(r);
                        }
                        case "/": {
                            return l.divide(r);
                        }
                        case "%": {
                            return new BigDecimal(l.intValue() % r.intValue());
                        }
                    }
                    throw new RuntimeException("\u4e0d\u8bc6\u522b\u7684\u7b97\u6570\u64cd\u4f5c\u7b26");
                }
                int l = Integer.parseInt(oLeft.toString());
                int r = Integer.parseInt(oRight.toString());
                switch (op) {
                    case "+": {
                        return l + r;
                    }
                    case "-": {
                        return l - r;
                    }
                    case "*": {
                        return l * r;
                    }
                    case "/": {
                        return l / r;
                    }
                    case "%": {
                        return l % r;
                    }
                }
                throw new RuntimeException("\u4e0d\u8bc6\u522b\u7684\u7b97\u6570\u64cd\u4f5c\u7b26");
            }

            @Override
            public IExpression partialCall(Delegate del, List<String> params) {
                return Expression.math(op, left.partialCall(del, params), right.partialCall(del, params));
            }

            public String toString() {
                return "Math(" + op + ", " + left.toString() + ", " + right.toString() + ")";
            }
        };
    }

    public static IExpression compare(final String op, final IExpression left, final IExpression right) {
        return new IExpression(){

            @Override
            public Object invoke(Delegate del) {
                Object l = left.invoke(del);
                Object r = right.invoke(del);
                if (l instanceof BigDecimal || r instanceof BigDecimal) {
                    l = new BigDecimal(l.toString());
                    r = new BigDecimal(r.toString());
                }
                if (l instanceof Comparable && r instanceof Comparable) {
                    int result = ((Comparable)l).compareTo(r);
                    switch (op) {
                        case ">": {
                            return result > 0;
                        }
                        case ">=": {
                            return result >= 0;
                        }
                        case "<": {
                            return result < 0;
                        }
                        case "<=": {
                            return result <= 0;
                        }
                        case "==": {
                            return result == 0;
                        }
                        case "!=": {
                            return result != 0;
                        }
                    }
                } else {
                    boolean equals = l.equals(r);
                    switch (op) {
                        case "==": {
                            return equals;
                        }
                        case "!=": {
                            return !equals;
                        }
                    }
                }
                return null;
            }

            @Override
            public IExpression partialCall(Delegate del, List<String> params) {
                return Expression.compare(op, left.partialCall(del, params), right.partialCall(del, params));
            }

            public String toString() {
                return "Compare(" + op + ", " + left.toString() + ", " + right.toString() + ")";
            }
        };
    }

    public static IExpression logic(final String op, final IExpression left, final IExpression right) {
        return new IExpression(){

            @Override
            public Object invoke(Delegate del) {
                boolean l = (Boolean)left.invoke(del);
                boolean r = (Boolean)right.invoke(del);
                switch (op) {
                    case "||": {
                        return l || r;
                    }
                    case "&&": {
                        return l && r;
                    }
                }
                throw new RuntimeException("\u672a\u77e5\u7c7b\u578b");
            }

            @Override
            public IExpression partialCall(Delegate del, List<String> params) {
                return Expression.logic(op, left.partialCall(del, params), right.partialCall(del, params));
            }

            public String toString() {
                return "Logic(" + op + ", " + left.toString() + ", " + right.toString() + ")";
            }
        };
    }

    public static IExpression not(final IExpression exp) {
        return new IExpression(){

            @Override
            public Object invoke(Delegate del) {
                return (Boolean)exp.invoke(del) == false;
            }

            @Override
            public IExpression partialCall(Delegate del, List<String> params) {
                return Expression.not(exp.partialCall(del, params));
            }

            public String toString() {
                return "Not(" + exp.toString() + ")";
            }
        };
    }

    public static IExpression json(final List<IExpression> children) {
        return new IExpression(){

            @Override
            public Object invoke(Delegate del) {
                JSONObject result = new JSONObject();
                for (IExpression child : children) {
                    Pair pair = (Pair)child.invoke(del);
                    result.put(pair.name, pair.value);
                }
                return result;
            }

            @Override
            public IExpression partialCall(Delegate del, List<String> params) {
                List<IExpression> result = children.stream().map(s -> s.partialCall(del, params)).collect(Collectors.toList());
                return Expression.json(result);
            }

            public String toString() {
                return "Json(" + children.toString() + ")";
            }
        };
    }

    public static IExpression attr(final String name, final IExpression v) {
        return new IExpression(){

            @Override
            public Object invoke(Delegate del) {
                return new Pair(name, v.invoke(del));
            }

            @Override
            public IExpression partialCall(Delegate del, List<String> params) {
                return Expression.attr(name, v.partialCall(del, params));
            }

            public String toString() {
                return "Attr(" + name + ", " + v.toString() + ")";
            }
        };
    }

    public static IExpression array(final List<IExpression> children) {
        return new IExpression(){

            @Override
            public Object invoke(Delegate del) {
                JSONArray result = new JSONArray();
                for (IExpression child : children) {
                    result.put(child.invoke(del));
                }
                return result;
            }

            @Override
            public IExpression partialCall(Delegate del, List<String> params) {
                List<IExpression> result = children.stream().map(s -> s.partialCall(del, params)).collect(Collectors.toList());
                return Expression.array(result);
            }

            public String toString() {
                return "Array(" + children.toString() + ")";
            }
        };
    }

    public static IExpression tuple(final List<IExpression> children) {
        return new IExpression(){

            @Override
            public Object invoke(Delegate del) {
                Object[] result = new Object[children.size()];
                int i = 0;
                for (IExpression child : children) {
                    result[i] = child.invoke(del);
                    ++i;
                }
                return result;
            }

            @Override
            public IExpression partialCall(Delegate del, List<String> params) {
                List<IExpression> result = children.stream().map(s -> s.partialCall(del, params)).collect(Collectors.toList());
                return Expression.tuple(result);
            }

            public String toString() {
                return "Tuple(" + children.toString() + ")";
            }
        };
    }

    public static IExpression deattach(final List<String> params, final IExpression exp) {
        return new IExpression(){

            @Override
            public Object invoke(Delegate del) {
                Object[] result = (Object[])exp.invoke(del);
                int i = 0;
                for (String name : params) {
                    del.putFunc(name, new LinkedList<Object>(), Expression.constant(result[i]));
                    ++i;
                }
                return null;
            }

            @Override
            public IExpression partialCall(Delegate del, List<String> invokeParams) {
                return Expression.deattach(params, exp.partialCall(del, invokeParams));
            }

            public String toString() {
                return "Deattach(" + params.toString() + ", " + exp.toString() + ")";
            }
        };
    }

    public static IExpression property(final IExpression objExp, final String name) {
        return new IExpression(){

            @Override
            public Object invoke(Delegate del) {
                Object obj = objExp.invoke(del);
                if (obj instanceof JSONObject) {
                    JSONObject json = (JSONObject)obj;
                    return json.get(name);
                }
                return new Delegate.JavaFunc(obj, name);
            }

            @Override
            public IExpression partialCall(Delegate del, List<String> params) {
                return Expression.property(objExp.partialCall(del, params), name);
            }

            public String toString() {
                return "Property(" + objExp.toString() + ", " + name + ")";
            }
        };
    }

    public static IExpression constant(final Object value) {
        return new IExpression(){

            @Override
            public Object invoke(Delegate del) {
                return value;
            }

            @Override
            public IExpression partialCall(Delegate del, List<String> params) {
                return Expression.constant(value);
            }

            public String toString() {
                return "Constant(" + value.toString() + ")";
            }
        };
    }

    public static IExpression func(final String name, final List<Object> params, final IExpression exp) {
        return new IExpression(){

            @Override
            public Object invoke(Delegate del) {
                del.putFunc(name, params, exp);
                return null;
            }

            @Override
            public IExpression partialCall(Delegate del, List<String> invokeParams) {
                return Expression.func(name, params, exp.partialCall(del, invokeParams));
            }

            public String toString() {
                return "Func(" + name + ", " + params.toString() + ", " + exp.toString() + ")";
            }
        };
    }

    public static IExpression mod(final String name, final IExpression exp) {
        return new IExpression(){

            @Override
            public Object invoke(Delegate del) {
                del.mods.put(name, exp);
                return null;
            }

            @Override
            public IExpression partialCall(Delegate del, List<String> invokeParams) {
                return Expression.mod(name, exp.partialCall(del, invokeParams));
            }

            public String toString() {
                return "mod(" + name + ", " + exp.toString() + ")";
            }
        };
    }

    public static IExpression modCall(final String modName, final String funcName) {
        return new IExpression(){

            @Override
            public Object invoke(Delegate del) {
                return new Delegate.ModFunc(modName, funcName);
            }

            @Override
            public IExpression partialCall(Delegate del, List<String> invokeParams) {
                return Expression.modCall(modName, funcName);
            }

            public String toString() {
                return "modCall(" + modName + ", " + funcName + ")";
            }
        };
    }

    public static IExpression funcName(final String name) {
        return new IExpression(){

            @Override
            public Object invoke(Delegate del) {
                if (del.plugins.containsKey(name)) {
                    return del.plugins.get(name);
                }
                if (del.funcs.containsKey(name)) {
                    Delegate.Func result = del.getFunc(name);
                    return result;
                }
                throw new RuntimeException("\u51fd\u6570\u4e0d\u5b58\u5728\uff1a" + name);
            }

            @Override
            public IExpression partialCall(Delegate del, List<String> names) {
                if (names.contains(name)) {
                    Object result = del.getFunc((String)name).body.invoke(del);
                    return Expression.constant(result);
                }
                return Expression.funcName(name);
            }

            public String toString() {
                return "funcName(" + name + ")";
            }
        };
    }

    public static IExpression condition(final List<TwoTuple<IExpression, IExpression>> conds, final IExpression elseExp) {
        return new IExpression(){

            @Override
            public Object invoke(Delegate del) {
                for (TwoTuple item : conds) {
                    if (!((Boolean)((IExpression)item.first).invoke(del)).booleanValue()) continue;
                    return ((IExpression)item.second).invoke(del);
                }
                return elseExp.invoke(del);
            }

            @Override
            public IExpression partialCall(Delegate del, List<String> names) {
                LinkedList<TwoTuple<IExpression, IExpression>> result = new LinkedList<TwoTuple<IExpression, IExpression>>();
                for (TwoTuple s : conds) {
                    result.add(new TwoTuple<IExpression, IExpression>(((IExpression)s.first).partialCall(del, names), ((IExpression)s.second).partialCall(del, names)));
                }
                return Expression.condition(result, elseExp.partialCall(del, names));
            }

            public String toString() {
                return "condition(" + conds.toString() + ", " + elseExp.toString() + ")";
            }
        };
    }

    public static IExpression concat(final IExpression left, final IExpression right) {
        return new IExpression(){

            @Override
            public Object invoke(Delegate del) {
                return left.invoke(del).toString() + right.invoke(del).toString();
            }

            @Override
            public IExpression partialCall(Delegate del, List<String> names) {
                return Expression.concat(left.partialCall(del, names), right.partialCall(del, names));
            }

            public String toString() {
                return "concat(" + left.toString() + ", " + right.toString() + ")";
            }
        };
    }

    public static IExpression call(final IExpression body, final List<IExpression> params) {
        return new IExpression(){

            @Override
            public Object invoke(Delegate del) {
                Object obj = body.invoke(del);
                if (obj instanceof Delegate.Func) {
                    return Expression.loopCall((Delegate.Func)obj, params, del, 0);
                }
                if (obj instanceof Delegate.ModFunc) {
                    Delegate.ModFunc func = (Delegate.ModFunc)obj;
                    return Expression.modCall(func.modName, func.funcName, params, del);
                }
                if (obj instanceof Delegate.JavaFunc) {
                    Delegate.JavaFunc func = (Delegate.JavaFunc)obj;
                    try {
                        return Expression.javaCall(func.obj, func.funcName, params, del);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                return obj;
            }

            @Override
            public IExpression partialCall(Delegate del, List<String> names) {
                List<IExpression> result = params.stream().map(s -> s.partialCall(del, names)).collect(Collectors.toList());
                return Expression.call(body.partialCall(del, names), result);
            }

            public String toString() {
                return "call(" + body.toString() + ", " + params.toString() + ")";
            }
        };
    }

    public static IExpression statement(final List<IExpression> states) {
        return new IExpression(){

            @Override
            public Object invoke(Delegate del) {
                Object result = null;
                for (IExpression child : states) {
                    result = child.invoke(del);
                }
                return result;
            }

            @Override
            public IExpression partialCall(Delegate del, List<String> names) {
                List<IExpression> result = states.stream().map(s -> s.partialCall(del, names)).collect(Collectors.toList());
                return Expression.statement(result);
            }

            public String toString() {
                return "statement(" + states.toString() + ")";
            }
        };
    }

    public static Object javaCall(Object obj, String funcName, List<IExpression> params, Delegate del) throws Exception {
        List realParams = params.stream().map(exp -> exp.invoke(del)).collect(Collectors.toList());
        Class[] paramTypes = (Class[])realParams.stream().map(p -> p.getClass()).toArray(Class[]::new);
        Method method = obj.getClass().getMethod(funcName, paramTypes);
        return method.invoke(obj, realParams.toArray());
    }

    public static Object modCall(String modName, String funcName, List<IExpression> params, Delegate del) {
        if (del.mods.containsKey(modName)) {
            IExpression exp = del.mods.get(modName);
            Delegate newDel = new Delegate();
            exp.invoke(newDel);
            if (newDel.funcs.containsKey(funcName)) {
                return Expression.loopCall(newDel.getFunc(funcName), params, newDel, 0);
            }
            throw new RuntimeException("\u51fd\u6570\u4e0d\u5b58\u5728\uff1a" + modName + ":" + funcName);
        }
        throw new RuntimeException("\u6a21\u5757\u4e0d\u5b58\u5728\uff1a" + modName + ":" + funcName);
    }

    public static Object loopCall(Delegate.Func func, List<IExpression> params, Delegate del, int start) {
        Object obj = Expression.oneCall(func, params, del, start);
        if (obj instanceof Delegate.Func) {
            Delegate.Func newFunc = (Delegate.Func)obj;
            if (newFunc.params.size() == 0 || params.size() > start + func.params.size()) {
                int newStart = start + func.params.size();
                return Expression.loopCall((Delegate.Func)obj, params, del, newStart);
            }
            return obj;
        }
        return obj;
    }

    public static Object oneCall(Delegate.Func func, List<IExpression> params, Delegate del, int start) {
        int i;
        Delegate newDel = del.clone();
        int len = func.params.size();
        for (i = 0; i + start < params.size() && i < len; ++i) {
            Expression.putParam(func.params.get(i), params.get(i + start), newDel);
        }
        Object result = Expression.funcCall(func, newDel, i);
        return result;
    }

    private static Object funcCall(Delegate.Func func, Delegate del, int num) {
        if (func.params.size() == num) {
            return func.body.invoke(del);
        }
        List<String> names = func.params.stream().limit(num).map(s -> s.toString()).collect(Collectors.toList());
        return new Delegate.Func(func.params.stream().skip(num).collect(Collectors.toList()), func.body.partialCall(del, names));
    }

    private static void putParam(Object param, IExpression exp, Delegate del) {
        if (param instanceof String) {
            IExpression e = Expression.constant(exp.invoke(del));
            del.putFunc((String)param, new LinkedList<Object>(), e);
        } else {
            Object[] values = (Object[])exp.invoke(del);
            int i = 0;
            for (Object p : (List)param) {
                Expression.putParam(p, Expression.constant(values[i]), del);
                ++i;
            }
        }
    }

    private static class Pair {
        String name;
        Object value;

        public Pair(String name, Object value) {
            this.name = name;
            this.value = value;
        }
    }
}

