package com.af.util;

import java.io.InputStream;
import java.io.IOException;

// 解析二进制文件时，需要的辅助类
public class ByteHelper {
    // 从输入流中获取32位整数
    public static int getInteger(InputStream ast) throws IOException {
        byte[] bytes = new byte[4];
        ast.read(bytes);
        return (bytes[0] << 24) + (bytes[1] << 16) + (bytes[2] << 8) + bytes[3];
    }

    // 获取8个字节的整数，前4个字节不用
    public static int getInteger8(InputStream ast) throws IOException {
        byte[] bytes = new byte[8];
        ast.read(bytes);
        return (bytes[4] << 24) + (bytes[5] << 16) + (bytes[6] << 8) + bytes[7];
    }

    // 获取8个字节的浮点数
    public static double getDouble(InputStream ast) throws Exception {
        byte[] bytes = new byte[8];
        ast.read(bytes);
        // 1到11位为指数位，共11位
        int e = ((bytes[0] & 0x7f) << 4) + ((bytes[1] & 0xf0) >> 4);
        // 从1023开始
        e = e - 1023;
        // 12位以后为小数位，共52位
        long l1 = ((long)(bytes[1] & 0x0f)) << 48;
        long l2 = ((long)bytes[2]) << 40;
        long l3 = ((long)bytes[3]) << 32;
        long l4 = ((long)bytes[4]) << 24;
        long l5 = ((long)bytes[5]) << 16;
        long l6 = ((long)bytes[6]) << 8;
        long l7 = (long)bytes[7];
        long p = l1 + l2 + l3 + l4 + l5 + l6 + l7;
        // 小数位计算方法
        double mant = 1 + p / Math.pow(2, 52); 
        // 第一位为符号位
        int sgn = (bytes[0] & 0x80) == 0 ? 1 : -1;
        
        // 根据规范，返回对应double内容
        if (e == 1024 && mant == 1)
            return sgn == 1 ? Double.POSITIVE_INFINITY : Double.NEGATIVE_INFINITY;
        if (e == 1024 && mant != 0)
            return Double.NaN;
        if (e == -1023)
            return sgn*Math.pow(2, -1022)*(mant - 1);
        return sgn*Math.pow(2, e)*mant;
    }
}