package com.af.func;

import com.af.util.TwoTuple;
import java.io.InputStream;
import java.util.Map;

// 运行给定的func语言书写的，编译后的ast文件
public class Runner {
    // ast：二进制的func语言的编译结果
    public static Object run(InputStream ast) throws Exception {
        // 把二进制转换成语法树
        IExpression exp = Expression.from(ast);
        // 返回语法节点的执行结果
        return exp.invoke(new Delegate());
    }

    // 带插件执行func语言
    public static Object run(InputStream ast, Map<String, Object> plugins) throws Exception {
        // 把二进制转换成语法树
        IExpression exp = Expression.from(ast);
        // 返回语法节点的执行结果
        return exp.invoke(new Delegate(plugins));
    }
}