package com.af.func;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

// 程序执行时的上下文环境
public class Delegate {
    // 函数定义
    public static class Func {
        public List<Object> params;
        public IExpression body;

        // 构造函数
        public Func(List<Object> params, IExpression body) {
            this.params = params;
            this.body = body;
        }

        // 转换成字符串
        public String toString() {
            return "Func(" + this.body + ", " + this.params + ")";
        }
    }

    // 模块中的函数，用模块名及函数名表示
    public static class ModFunc {
        public String modName;
        public String funcName;
        public ModFunc(String modName, String funcName) {
            this.modName = modName;
            this.funcName = funcName;
        }
    }

    // java对象的函数，用java对象及函数名表示
    public static class JavaFunc {
        public Object obj;
        public String funcName;
        public JavaFunc(Object obj, String funcName) {
            this.obj = obj;
            this.funcName = funcName;
        }
    }

    // 插件定一个表
    public Map<String, Object> plugins = new HashMap<>();

    // 函数定义表
    public Map<String, Func> funcs = new HashMap<>();

    // 模块定义表
    public Map<String, IExpression> mods = new HashMap<>();

    // 空构造
    public Delegate() {
    }

    // 带插件定义构造
    public Delegate(Map<String, Object> plugins) {
        this.plugins = plugins;
    }

    // 添加函数定义
    public void putFunc(String name, List<Object> params, IExpression body) {
        this.funcs.put(name, new Func(params, body));
    }

    // 找到函数定义
    public Func getFunc(String name) {
        Func result = this.funcs.get(name);
        if(result == null) {
            throw new RuntimeException("函数不存在:" + name);
        }
        return result;
    }

    // 复制上下文环境
    public Delegate clone() {
        Delegate result = new Delegate();
        // 复制函数
        this.funcs.forEach((key, value) -> {
            result.funcs.put(key, value);
        });
        // 复制插件
        result.plugins = this.plugins;
        return result;
    }
}
