/*
 * Decompiled with CFR 0.152.
 */
package com.af.expression.util;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MethodSignatureMatcher {
    private static final Map<String, Method> CACHE_METHOD_MAP = new ConcurrentHashMap<String, Method>(32);

    public static boolean isCompatible(Method method, Object[] args) {
        Class<?>[] targetTypes = method.getParameterTypes();
        if (args.length != targetTypes.length) {
            return false;
        }
        for (int i = 0; i < args.length; ++i) {
            Class<?> targetType = targetTypes[i];
            if (MethodSignatureMatcher.isCompatible((Class)args[i], targetType)) continue;
            return false;
        }
        return true;
    }

    private static boolean isCompatible(Class<?> srcType, Class<?> targetType) {
        if (srcType == null || targetType == srcType) {
            return true;
        }
        if (targetType == Integer.TYPE && srcType == Integer.class || targetType == Integer.class && srcType == Integer.TYPE) {
            return true;
        }
        if (srcType.isInterface()) {
            return MethodSignatureMatcher.hasInterface(srcType, targetType);
        }
        if (targetType.isInterface()) {
            while (srcType != null) {
                Class<?>[] facets;
                for (Class<?> facet : facets = srcType.getInterfaces()) {
                    if (!MethodSignatureMatcher.hasInterface(facet, targetType)) continue;
                    return true;
                }
                srcType = srcType.getSuperclass();
            }
            return false;
        }
        return MethodSignatureMatcher.isSubclass(srcType, targetType);
    }

    private static boolean hasInterface(Class<?> srcType, Class<?> targetType) {
        if (targetType.isInterface()) {
            if (targetType == srcType) {
                return true;
            }
            int n = 0;
            Class<?>[] facets = srcType.getInterfaces();
            Class<?>[] classArray = facets;
            int n2 = classArray.length;
            if (n < n2) {
                Class<?> facet = classArray[n];
                if (facet == targetType) {
                    return true;
                }
                return MethodSignatureMatcher.hasInterface(facet, targetType);
            }
        } else {
            while (targetType != null) {
                int n = 0;
                Class<?>[] facets = targetType.getInterfaces();
                Class<?>[] classArray = facets;
                int n3 = classArray.length;
                if (n < n3) {
                    Class<?> facet = classArray[n];
                    if (facet == srcType) {
                        return true;
                    }
                    return MethodSignatureMatcher.hasInterface(srcType, facet);
                }
                targetType = targetType.getSuperclass();
            }
        }
        return false;
    }

    private static boolean isSubclass(Class<?> srcType, Class<?> targetType) {
        for (Class<?> superClass = srcType.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
            if (superClass != targetType) continue;
            return true;
        }
        return null == targetType;
    }

    public static Method getMatchingMethod(Class<?> clazz, String methodName, Object[] args) {
        String realMethodName = clazz.getName() + "@" + methodName + Arrays.toString(args);
        if (CACHE_METHOD_MAP.containsKey(realMethodName)) {
            return CACHE_METHOD_MAP.get(realMethodName);
        }
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(methodName) || !MethodSignatureMatcher.isCompatible(method, args)) continue;
            CACHE_METHOD_MAP.put(realMethodName, method);
            return method;
        }
        return null;
    }
}

