package com.af.expression;

/**
 * 表达式类型
 *
 * @author LocalUser
 */
public enum ExpressionType {

	//>
	GreaterThan,
	//>=
	GreaterThanOrEqual,
	//<
	LessThan,
	//<=
	LessThanOrEqual,
	//==
	Equal,
	//!=
	NotEqual,
	//+
	Add,
	//-
	Subtract,
	//*
	Multiply,
	//除法
	Divide,
	//求余
	Modulo,

	//字符串连接
	Concat,
	//逻辑非
	Not,
	//逻辑与
	And,
	//逻辑或
	Or,

	//常数
	Constant,
	//标识符
	Identity,

	//获取对象属性
	Property,

	//产生Json对象
	Json,
	//产生Json数组
	Array,
	//Json对象属性值对
	Attr,
	//数组下标，[0]
	ArrayIndex,
	//函数调用
	Call,
	//for循环
	For,
	//逗号表达式
	Comma,
	//赋值语句
	Assign,
	//条件语句
	Condition,
	//参数
	Param,
	//Try
	Try,
	//Catch
	Catch,
	//跳出
	Return,
	//抛出异常
	Throw,
	//校验
	Validate,
	//断言
	Assert,
	//循环终止
	Break,
	//循环跳过
	Continue
}
