package com.af.expression.enums;

import java.util.stream.Stream;

/**
 * 校验模式
 */
public enum ValidateMode {
    /**
     * 标准（单参数校验）
     */
    NORMAL("normal"),
    /**
     * 至少一个（多参数中必填一个）
     */
    AT_LEAST_ONE("atLeastOne");

    private final String value;

    ValidateMode(String value) {
        this.value = value;
    }

    public static ValidateMode toType(String value) {
        return Stream.of(ValidateMode.values())
                .filter(p -> p.value.equals(value))
                .findAny()
                .orElse(null);
    }

    public static boolean is(String value) {
        return toType(value) != null;
    }

    public String getValue() {
        return value;
    }
}
