/*
 * Decompiled with CFR 0.152.
 */
package com.af.expression;

import com.af.expression.Delegate;
import com.af.expression.ExpressionException;
import com.af.expression.ExpressionType;
import com.af.expression.PropertyNotFoundException;
import com.af.util.MethodSignatureMatcher;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class Expression {
    public ExpressionType type;
    public Object value;
    public List<Expression> children = new ArrayList<Expression>();
    public Delegate delegate;
    private String source;
    private int pos;

    private Expression(ExpressionType type, String source, int pos) {
        this.type = type;
        this.source = source;
        this.pos = pos;
    }

    private Expression(ExpressionType type, Object value, String source, int pos) {
        this.type = type;
        this.value = value;
        this.source = source;
        this.pos = pos;
    }

    public String toString() {
        String result = "type: " + (Object)((Object)this.type) + ", value: " + (this.value != null ? this.value.toString() : "null") + "[\n";
        for (Expression child : this.children) {
            result = result + (child != null ? child.toString() : "null\n");
        }
        result = result + "]";
        return result;
    }

    public Delegate Compile() {
        Delegate result = new Delegate(this);
        return result;
    }

    /*
     * Unable to fully structure code
     */
    public Object invoke() {
        try {
            switch (1.$SwitchMap$com$af$expression$ExpressionType[this.type.ordinal()]) {
                case 1: 
                case 2: {
                    left = this.children.get(0);
                    right = this.children.get(1);
                    l = this.getBoolean(left.invoke());
                    r = this.getBoolean(right.invoke());
                    switch (1.$SwitchMap$com$af$expression$ExpressionType[this.type.ordinal()]) {
                        case 1: {
                            return l != false || r != false;
                        }
                        case 2: {
                            return l != false && r != false;
                        }
                    }
                }
                case 9: {
                    left = this.children.get(0);
                    l = this.getBoolean(left.invoke());
                    return l == false;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    return this.math();
                }
                case 15: {
                    left = this.children.get(0);
                    right = this.children.get(1);
                    l = left.invoke();
                    r = right.invoke();
                    return l.toString() + r.toString();
                }
                case 16: {
                    return this.Json();
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    left = this.children.get(0);
                    right = this.children.get(1);
                    l = left.invoke();
                    r = right.invoke();
                    if (!(l instanceof String) || !(r instanceof String)) ** GOTO lbl44
                    result = ((String)l).compareTo((String)r);
                    switch (1.$SwitchMap$com$af$expression$ExpressionType[this.type.ordinal()]) {
                        case 3: {
                            return result > 0;
                        }
                        case 4: {
                            return result >= 0;
                        }
                        case 5: {
                            return result < 0;
                        }
                        case 6: {
                            return result <= 0;
                        }
                    }
                    ** GOTO lbl56
lbl44:
                    // 1 sources

                    dl = new BigDecimal(l.toString());
                    dr = new BigDecimal(r.toString());
                    cr = dl.compareTo(dr);
                    switch (1.$SwitchMap$com$af$expression$ExpressionType[this.type.ordinal()]) {
                        case 3: {
                            return cr > 0;
                        }
                        case 4: {
                            return cr >= 0;
                        }
                        case 5: {
                            return cr < 0;
                        }
                        case 6: {
                            return cr <= 0;
                        }
                    }
                }
lbl56:
                // 3 sources

                case 7: 
                case 8: {
                    left = this.children.get(0);
                    right = this.children.get(1);
                    l = left.invoke();
                    if (l == null) {
                        l = "null";
                    }
                    if ((r = right.invoke()) == null) {
                        r = "null";
                    }
                    switch (1.$SwitchMap$com$af$expression$ExpressionType[this.type.ordinal()]) {
                        case 7: {
                            return l.toString().equals(r.toString());
                        }
                        case 8: {
                            return l.toString().equals(r.toString()) == false;
                        }
                    }
                }
                case 17: {
                    if (this.value instanceof Double) {
                        return new BigDecimal(this.value.toString());
                    }
                    return this.value;
                }
                case 18: {
                    name = (String)this.value;
                    if (!this.delegate.objectNames.containsKey(name)) {
                        throw new PropertyNotFoundException(name);
                    }
                    return this.delegate.objectNames.get(name);
                }
                case 19: {
                    return this.condition();
                }
                case 20: {
                    return this.property();
                }
                case 21: {
                    return this.arrayIndex();
                }
                case 22: {
                    return this.call();
                }
                case 23: {
                    return this.loop();
                }
                case 24: {
                    return this.assign();
                }
                case 25: {
                    value = 0;
                    for (Expression child : this.children) {
                        value = child.invoke();
                    }
                    return value;
                }
            }
            throw new RuntimeException("\u65e0\u6548\u64cd\u4f5c");
        }
        catch (ExpressionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new ExpressionException(this.source, this.pos, ex);
        }
    }

    private Object math() {
        Expression left = this.children.get(0);
        Expression right = this.children.get(1);
        Object oLeft = left.invoke();
        Object oRight = right.invoke();
        if (oLeft instanceof BigDecimal || oRight instanceof BigDecimal) {
            BigDecimal l = new BigDecimal(left.invoke().toString());
            BigDecimal r = new BigDecimal(right.invoke().toString());
            switch (this.type) {
                case Add: {
                    return l.add(r);
                }
                case Subtract: {
                    return l.subtract(r);
                }
                case Multiply: {
                    return l.multiply(r);
                }
                case Divide: {
                    return l.divide(r);
                }
                case Modulo: {
                    return new BigDecimal(l.intValue() % r.intValue());
                }
            }
        } else {
            int l = Integer.parseInt(left.invoke().toString());
            int r = Integer.parseInt(right.invoke().toString());
            switch (this.type) {
                case Add: {
                    return l + r;
                }
                case Subtract: {
                    return l - r;
                }
                case Multiply: {
                    return l * r;
                }
                case Divide: {
                    return l / r;
                }
                case Modulo: {
                    return l % r;
                }
            }
        }
        throw new RuntimeException("\u4e0d\u8bc6\u522b\u7684\u7b97\u6570\u64cd\u4f5c\u7b26");
    }

    private Object condition() {
        Expression condExp = this.children.get(0);
        Expression isTrue = this.children.get(1);
        Expression isFalse = this.children.get(2);
        Object obj = condExp.invoke();
        boolean cond = this.getBoolean(obj);
        if (cond) {
            return isTrue.invoke();
        }
        return isFalse.invoke();
    }

    private Object loop() throws Exception {
        Expression objExp = this.children.get(0);
        JSONArray array = (JSONArray)objExp.invoke();
        Expression body = this.children.get(1);
        for (int i = 0; i < array.length(); ++i) {
            body.delegate.objectNames.put("row", array.get(i));
            body.invoke();
        }
        return null;
    }

    private Object where() throws Exception {
        JSONArray result = new JSONArray();
        Expression objExp = this.children.get(0);
        JSONArray array = null;
        Object ret = objExp.invoke();
        if (ret instanceof JSONArray) {
            array = (JSONArray)ret;
        } else if (ret instanceof List) {
            array = new JSONArray();
            List list = (List)ret;
            for (Object value : list) {
                array.put(value);
            }
        } else {
            throw new RuntimeException("where\u51fd\u6570\u53ea\u652f\u6301JSONArray, List");
        }
        Expression body = this.children.get(1);
        for (int i = 0; i < array.length(); ++i) {
            Object value;
            value = array.get(i);
            body.delegate.objectNames.put("row", value);
            if (!body.invoke().equals(true)) continue;
            result.put(value);
        }
        return result;
    }

    private Object sum() throws Exception {
        BigDecimal result = new BigDecimal(0);
        Expression objExp = this.children.get(0);
        JSONArray array = (JSONArray)objExp.invoke();
        Expression body = this.children.get(1);
        for (int i = 0; i < array.length(); ++i) {
            Object value = array.get(i);
            body.delegate.objectNames.put("row", value);
            Object decimal = body.invoke();
            result = decimal == null ? result.add(new BigDecimal(0)) : result.add(new BigDecimal(decimal.toString()));
        }
        return result;
    }

    private Object call() throws Exception {
        String name = (String)this.value;
        if (name.equals("where")) {
            return this.where();
        }
        if (name.equals("sum")) {
            return this.sum();
        }
        Expression objExp = this.children.get(0);
        Object obj = objExp.invoke();
        ArrayList<Object> params = new ArrayList<Object>();
        for (int i = 1; i < this.children.size(); ++i) {
            Expression paramExp = this.children.get(i);
            params.add(paramExp.invoke());
        }
        Object[] types = new Object[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            types[i] = params.get(i).getClass();
        }
        try {
            Method method = MethodSignatureMatcher.getMatchingMethod(obj.getClass(), name, types);
            Object oCall = method.invoke(obj, params.toArray());
            return this.convert(oCall);
        }
        catch (Exception e) {
            throw new RuntimeException("\u51fd\u6570\u8c03\u7528\u9519\u8bef\uff1a" + name, e);
        }
    }

    private Object convert(Object source) {
        if (source instanceof Double) {
            return new BigDecimal(source.toString());
        }
        if (source instanceof Byte || source instanceof Short || source instanceof Integer || source instanceof Long) {
            return new Integer(source.toString());
        }
        return source;
    }

    private Object assign() {
        Expression right = this.children.get(1);
        Object value = right.invoke();
        String name = (String)this.value;
        Expression left = this.children.get(0);
        if (left == null) {
            this.delegate.objectNames.put(name, value);
        } else {
            Object obj = left.invoke();
            if (obj instanceof JSONObject) {
                JSONObject json = (JSONObject)obj;
                json.put(name, value);
            } else {
                try {
                    Field field = obj.getClass().getField(name);
                    field.set(obj, value);
                    return value;
                }
                catch (Exception e) {
                    throw new RuntimeException("\u5c5e\u6027\u8d4b\u503c\u9519\u8bef\uff1a" + name);
                }
            }
        }
        return value;
    }

    private Object property() throws Exception {
        Expression objExp = this.children.get(0);
        Object obj = objExp.invoke();
        String name = (String)this.value;
        Object rObj = null;
        if (obj.getClass() == HashMap.class) {
            Map map = (Map)obj;
            if (!map.containsKey(name)) {
                throw new PropertyNotFoundException(name);
            }
            rObj = map.get(name);
        } else if (obj instanceof JSONObject) {
            JSONObject json = (JSONObject)obj;
            if (!json.has(name)) {
                throw new PropertyNotFoundException(name);
            }
            rObj = json.get(name);
        } else {
            Field field = obj.getClass().getField(name);
            if (field == null) {
                throw new PropertyNotFoundException(name);
            }
            rObj = field.get(obj);
        }
        return this.convert(rObj);
    }

    private Object arrayIndex() throws Exception {
        Expression objExp = this.children.get(0);
        Expression indexExp = this.children.get(1);
        Object obj = objExp.invoke();
        int index = Integer.parseInt(indexExp.invoke().toString());
        if (obj instanceof JSONArray) {
            JSONArray array = (JSONArray)obj;
            Object oRet = array.get(index);
            return this.convert(oRet);
        }
        throw new ExpressionException(this.source, this.pos);
    }

    private Object Json() throws Exception {
        JSONObject result = new JSONObject();
        for (Expression child : this.children) {
            String name = child.value.toString();
            try {
                Object value = child.children.get(0).invoke();
                result.put(name, value);
            }
            catch (Exception e) {
                if (this.delegate.CanJsonPropertyChoise && e.getCause() instanceof PropertyNotFoundException) continue;
                throw e;
            }
        }
        return result;
    }

    private boolean getBoolean(Object obj) {
        boolean cond = false;
        cond = obj instanceof Boolean ? (Boolean)obj : obj != null;
        return cond;
    }

    public static Expression Constant(Object value, String source, int pos) {
        Expression result = new Expression(ExpressionType.Constant, value, source, pos);
        return result;
    }

    public static Expression Identy(Object value, String source, int pos) {
        Expression result = new Expression(ExpressionType.Identy, value, source, pos);
        return result;
    }

    public static Expression Property(Expression objExp, String name, String source, int pos) {
        Expression result = new Expression(ExpressionType.Property, name, source, pos);
        result.children.add(objExp);
        return result;
    }

    public static Expression Json(List<Expression> attrs, String source, int pos) {
        Expression result = new Expression(ExpressionType.Json, source, pos);
        for (Expression exp : attrs) {
            result.children.add(exp);
        }
        return result;
    }

    public static Expression Attr(String name, Expression value, String source, int pos) {
        Expression result = new Expression(ExpressionType.Attr, source, pos);
        result.value = name;
        result.children.add(value);
        return result;
    }

    public static Expression Comma(List<Expression> children, String source, int pos) {
        Expression result = new Expression(ExpressionType.Comma, source, pos);
        for (Expression exp : children) {
            result.children.add(exp);
        }
        return result;
    }

    public static Expression Assign(Expression objExp, Expression exp, String name, String source, int pos) {
        Expression result = new Expression(ExpressionType.Assign, name, source, pos);
        result.children.add(objExp);
        result.children.add(exp);
        return result;
    }

    public static Expression Call(Expression objExp, String name, List<Expression> params, String source, int pos) {
        Expression result = new Expression(ExpressionType.Call, name, source, pos);
        result.children.add(objExp);
        for (Expression param : params) {
            result.children.add(param);
        }
        return result;
    }

    public static Expression Condition(Expression test, Expression ifTrue, Expression ifFalse, String source, int pos) {
        Expression result = new Expression(ExpressionType.Condition, source, pos);
        result.children.add(test);
        result.children.add(ifTrue);
        result.children.add(ifFalse);
        return result;
    }

    public static Expression Not(Expression exp, String source, int pos) {
        Expression result = new Expression(ExpressionType.Not, source, pos);
        result.children.add(exp);
        return result;
    }

    public static Expression And(Expression left, Expression right, String source, int pos) {
        Expression result = new Expression(ExpressionType.And, source, pos);
        result.children.add(left);
        result.children.add(right);
        return result;
    }

    public static Expression Or(Expression left, Expression right, String source, int pos) {
        Expression result = new Expression(ExpressionType.Or, source, pos);
        result.children.add(left);
        result.children.add(right);
        return result;
    }

    public static Expression GreaterThan(Expression left, Expression right, String source, int pos) {
        Expression result = new Expression(ExpressionType.GreaterThan, source, pos);
        result.children.add(left);
        result.children.add(right);
        return result;
    }

    public static Expression GreaterThanOrEqual(Expression left, Expression right, String source, int pos) {
        Expression result = new Expression(ExpressionType.GreaterThanOrEqual, source, pos);
        result.children.add(left);
        result.children.add(right);
        return result;
    }

    public static Expression LessThan(Expression left, Expression right, String source, int pos) {
        Expression result = new Expression(ExpressionType.LessThan, source, pos);
        result.children.add(left);
        result.children.add(right);
        return result;
    }

    public static Expression LessThanOrEqual(Expression left, Expression right, String source, int pos) {
        Expression result = new Expression(ExpressionType.LessThanOrEqual, source, pos);
        result.children.add(left);
        result.children.add(right);
        return result;
    }

    public static Expression Equal(Expression left, Expression right, String source, int pos) {
        Expression result = new Expression(ExpressionType.Equal, source, pos);
        result.children.add(left);
        result.children.add(right);
        return result;
    }

    public static Expression NotEqual(Expression left, Expression right, String source, int pos) {
        Expression result = new Expression(ExpressionType.NotEqual, source, pos);
        result.children.add(left);
        result.children.add(right);
        return result;
    }

    public static Expression Add(Expression left, Expression right, String source, int pos) {
        Expression result = new Expression(ExpressionType.Add, source, pos);
        result.children.add(left);
        result.children.add(right);
        return result;
    }

    public static Expression Subtract(Expression left, Expression right, String source, int pos) {
        Expression result = new Expression(ExpressionType.Subtract, source, pos);
        result.children.add(left);
        result.children.add(right);
        return result;
    }

    public static Expression Multiply(Expression left, Expression right, String source, int pos) {
        Expression result = new Expression(ExpressionType.Multiply, source, pos);
        result.children.add(left);
        result.children.add(right);
        return result;
    }

    public static Expression Divide(Expression left, Expression right, String source, int pos) {
        Expression result = new Expression(ExpressionType.Divide, source, pos);
        result.children.add(left);
        result.children.add(right);
        return result;
    }

    public static Expression Modulo(Expression left, Expression right, String source, int pos) {
        Expression result = new Expression(ExpressionType.Modulo, source, pos);
        result.children.add(left);
        result.children.add(right);
        return result;
    }

    public static Expression Concat(Expression left, Expression right, String source, int pos) {
        Expression result = new Expression(ExpressionType.Concat, source, pos);
        result.children.add(left);
        result.children.add(right);
        return result;
    }

    public static Expression ArrayIndex(Expression objExp, Expression indexExp, String source, int pos) {
        Expression result = new Expression(ExpressionType.ArrayIndex, source, pos);
        result.children.add(objExp);
        result.children.add(indexExp);
        return result;
    }

    public static Expression For(Expression objExp, Expression forExp, String source, int pos) {
        Expression result = new Expression(ExpressionType.For, source, pos);
        result.children.add(objExp);
        result.children.add(forExp);
        return result;
    }
}

