/*
 * Decompiled with CFR 0.152.
 */
package com.af.websocket;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketMessage;
import org.springframework.web.socket.WebSocketSession;

public class MyWebSocketHandler
implements WebSocketHandler {
    private static final Map<String, WebSocketSession> users = new HashMap<String, WebSocketSession>();

    public void afterConnectionEstablished(WebSocketSession session) throws Exception {
        System.out.println("\u5efa\u7acb\u8fde\u63a5\u540e");
        Object token = session.getAttributes().get("token");
        users.put(session.getId(), session);
        System.out.println(token);
    }

    public void handleMessage(WebSocketSession session, WebSocketMessage<?> message) throws Exception {
        if (message.getPayload().equals("ping")) {
            System.out.println("ping");
            session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)"pong"));
            return;
        }
        System.out.println("\u5904\u7406\u4fe1\u606f");
    }

    public void handleTransportError(WebSocketSession session, Throwable exception) throws Exception {
        System.out.println("\u5904\u7406\u4f20\u8f93\u65f6\u5f02\u5e38");
        if (session.isOpen()) {
            session.close();
        }
        users.remove(session.getId());
    }

    public void afterConnectionClosed(WebSocketSession session, CloseStatus closeStatus) throws Exception {
        System.out.println("\u8fde\u63a5\u5173\u95ed");
        users.remove(session.getId());
    }

    public boolean supportsPartialMessages() {
        return false;
    }

    public void sendMessageToUsers(JSONArray users, String type, String message, Object data, String sender) {
        users.forEach(item -> this.sendMessageToUser(item.toString(), type, message, data, sender));
    }

    public void sendMessageToUser(String token, String type, String message, Object data, String sender) {
        JSONObject json = new JSONObject();
        json.put("type", (Object)type);
        json.put("message", (Object)message);
        json.put("data", data);
        json.put("sender", (Object)sender);
        Iterator<Map.Entry<String, WebSocketSession>> it = this.userIterator();
        while (it.hasNext()) {
            WebSocketSession session = it.next().getValue();
            if (!token.equals(session.getAttributes().get("token"))) continue;
            try {
                if (!session.isOpen()) continue;
                session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)json.toString()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void sendMessageToAllUser(String type, String message, Object data, String sender) {
        JSONObject json = new JSONObject();
        json.put("type", (Object)type);
        json.put("message", (Object)message);
        json.put("data", data);
        json.put("sender", (Object)sender);
        Iterator<Map.Entry<String, WebSocketSession>> it = this.userIterator();
        while (it.hasNext()) {
            WebSocketSession session = it.next().getValue();
            try {
                if (!session.isOpen()) continue;
                session.sendMessage((WebSocketMessage)new TextMessage((CharSequence)json.toString()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public JSONArray onlineUser() {
        JSONArray array = new JSONArray();
        Iterator<Map.Entry<String, WebSocketSession>> it = this.userIterator();
        while (it.hasNext()) {
            WebSocketSession session = it.next().getValue();
            array.put(session.getAttributes().get("token"));
        }
        return array;
    }

    private Iterator<Map.Entry<String, WebSocketSession>> userIterator() {
        Set<Map.Entry<String, WebSocketSession>> entrys = users.entrySet();
        return entrys.iterator();
    }
}

